<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice',
        'type' => 'type',
        'label' => 'verband_id',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'delete' => 'deleted',
        'searchFields' => 'verband_id,entry_id,tablenames,position,periode,mode,create_date, modified_date, invoice_date,paid_date, subtotal, subtotal_exkl, discount_percentage, discount_amount, total_discount, tax_rate, rounding_step, total_tax, total_exkl, total, pre_payment_credit_amount, post_payment_credit_amount, amount_paid, letter_date,invoiceitem,status,art, customer_reference, description',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_invoice.gif'
    ],
    'types' => [
        '0' => ['showitem' => 'type, verband_id, entry_id, tablenames, position, periode, mode, create_date, modified_date, invoice_date, paid_date, subtotal, subtotal_exkl, discount_percentage, discount_amount, total_discount, tax_rate, rounding_step, total_tax, total_exkl, total, pre_payment_credit_amount, post_payment_credit_amount, amount_paid, letter_date, invoiceitem, status, art, customer_reference, description'],
        'Invoice' => ['showitem' => 'type, verband_id, entry_id, tablenames, position, periode, mode, create_date, modified_date, invoice_date, paid_date, subtotal, subtotal_exkl, discount_percentage, discount_amount, total_discount, tax_rate, rounding_step, total_tax, total_exkl, total, pre_payment_credit_amount, post_payment_credit_amount, amount_paid, letter_date, invoiceitem, status, art, customer_reference, description'],
        'InvoiceAnnual' => ['showitem' => 'type, verband_id, entry_id, tablenames, position, periode, mode, create_date, modified_date, invoice_date, paid_date, subtotal, subtotal_exkl, discount_percentage, discount_amount, total_discount, tax_rate, rounding_step, total_tax, total_exkl, total, pre_payment_credit_amount, post_payment_credit_amount, amount_paid, letter_date, invoiceitem, status, art, customer_reference, description'],
        
    ],
    'columns' => [

        'type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.type.invoice', 'value' => 'Invoice' ],
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.type.invoiceAnnual', 'value' => 'InvoiceAnnual'],
                ],
                'default' => 'Invoice',
                'nullable' => true,
            ],
        ],
        'verband_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.verband_id',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'entry_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.entry_id',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'tablenames' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.tablenames',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
        'position' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.position',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'periode' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.periode',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'mode' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.mode',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'create_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.create_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date'
            ],
        ],
        'modified_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.modified_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date'
            ],
        ],
        'invoice_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.invoice_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
                'nullable' => true
            ],
        ],
        'paid_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.paid_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
                'nullable' => true,
            ],
        ],
        'subtotal' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.subtotal',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'subtotal_exkl' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.subtotal_exkl',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'discount_percentage' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.discount_percentage',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'discount_amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.discount_amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'total_discount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.total_discount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'tax_rate' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.tax_rate',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'rounding_step' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.rounding_step',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'total_tax' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.total_tax',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'total_exkl' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.total_exkl',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'total' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.total',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'pre_payment_credit_amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.pre_payment_credit_amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'post_payment_credit_amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.post_payment_credit_amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'amount_paid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.amount_paid',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'letter_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.letter_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
                'nullable' => true,
            ],
        ],
        'invoiceitem' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.invoiceitem',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_igfibu_domain_model_invoiceitem',
                'foreign_sortby' => 'sorting',
                'foreign_field' => 'invoice',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => true,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1
                ],
            ],

        ],
        'status' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.status',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igfibu_domain_model_invoicestatus',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'art' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.art',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igfibu_domain_model_invoicescheme',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'customer_reference' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.customer_reference',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.description',
            'config' => [
               'type' => 'text',
                'cols' => 40,
                'rows' => 3,
                'eval' => 'trim'
            ],
        ],
        'invoice_address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.invoice_address',
            'config' => [
               'type' => 'text',
                'cols' => 40,
                'rows' => 3,
                'eval' => 'trim'
            ],
        ],
        'delivery_address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.delivery_address',
            'config' => [
               'type' => 'text',
                'cols' => 40,
                'rows' => 3,
                'eval' => 'trim'
            ],
        ],


        
    ],
];
