<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

use Ig\IgFibu\Service\DebitorService;

use TYPO3\CMS\Core\Database\Query\QueryBuilder;

class BaseQueryBuilder extends QueryBuilder
{
    protected $entryTablename = null;
    protected $entryPrimaryKey = 'uid';
    protected $tenantIdAttribute = 'verband_id';

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;


    /**
     * Select
     *
     * @var Select
     */
    protected $sqlSelect = '*';


    
    public function injectDebitorService(DebitorService $debitorService): void
    {
        $this->debitorService = $debitorService;
    }

    public function resetSelect()
    {
        $this->sqlSelect = '*';
        return $this;
    }


    public function setEntryTablename($entryTablename)
    {
        $this->entryTablename = $entryTablename;
        return $this;
    }

    public function getEntryTablename()
    {
        return $this->entryTablename;
    }

    public function setEntryPrimaryKey($entryPrimaryKey)
    {
        $this->entryPrimaryKey = $entryPrimaryKey;
        return $this;
    }

    public function getEntryPrimaryKey()
    {
        return $this->entryPrimaryKey;
    }

    public function addUserRestriction()
    {
        $constraints = $this->debitorService->userRestriction($this, $this->tablename);
        
        //if ($this->settings['mandant']['active']) {
        $verbands = $this->debitorService->getMandants(true);
        $tenantsIds = [];
        foreach ($verbands as $verband) {
            $tenantsIds[] = $verband['uid'];
        }
        if (!empty($tenantsIds)) {
            $constraints[] = $this->expr()->in($this->tenantIdAttribute, $tenantsIds);
        }

        //       }
        
        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
    /**
     * equal range constraints
     */
    protected function addEqualRangeConstrain(array $constraints, string $attribute, array $searchEntry = null)
    {
        if ($searchEntry === null) {
            return $constraints;
        }
        $mode = $searchEntry['mode'] ?? null;
        if ($mode === 'equal' || $mode === null) {
            if (isset($searchEntry['equal']) && $searchEntry['equal'] !== '') {
                $constraints[] = $this->expr()->eq($attribute, $this->createNamedParameter($searchEntry['equal']));
            }
        }
        if ($mode === 'range' || $mode === null) {
            if (isset($searchEntry['from']) && $searchEntry['from'] !== '') {
                $constraints[] = $this->expr()->gte($attribute, $this->createNamedParameter($searchEntry['from']));
            }
            if (isset($searchEntry['to']) && $searchEntry['to'] !== '') {
                $constraints[] = $this->expr()->lte($attribute, $this->createNamedParameter($searchEntry['to']));
            }
        }
        return $constraints;
    }

    protected function addRawEqualRangeConstrain(array $constraints, string $attribute, array $searchEntry = null)
    {
        if ($searchEntry === null) {
            return $constraints;
        }
        $mode = $searchEntry['mode'] ?? null;
        if ($mode === 'equal' || $mode === null) {
            if (isset($searchEntry['equal']) && $searchEntry['equal'] !== '') {
                $constraints[] = $attribute . '=' . $this->createNamedParameter($searchEntry['equal']);
            }
        }
        if ($mode === 'range' || $mode === null) {
            if (isset($searchEntry['from']) && $searchEntry['from'] !== '') {
                $constraints[] = $attribute . '>=' . $this->createNamedParameter($searchEntry['from']);
            }
            if (isset($searchEntry['to']) && $searchEntry['to'] !== '') {
                $constraints[] = $attribute . '<=' . $this->createNamedParameter($searchEntry['to']);
            }
        }
        return $constraints;
    }
}
