<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoiceQueryBuilder extends BaseQueryBuilder
{
    public $deliveryMethodStatusIds = [1, 2, 16];
    protected $tablename = 'tx_igfibu_domain_model_invoice';
    protected $invoicestatusTablename = 'tx_igfibu_domain_model_invoicestatus';
    protected $invoicestatusJoined = false;
    protected $invoicepaymentTablename = 'tx_igfibu_domain_model_invoicepayment';

    /*
    public function addSelectPayments()
    {
        $this->addSelectLiteral('(SELECT SUM(betrag) FROM tx_igfibu_domain_model_payment WHERE deleted=0 AND is_ok AND invoice = tx_igfibu_domain_model_invoice.uid) AS payments');
    }
    */
    public function joinInvoicestatus(): void
    {
        if (!$this->invoicestatusJoined) {
            $this->join(
                $this->tablename,
                $this->invoicestatusTablename,
                $this->invoicestatusTablename,
                $this->expr()
->eq($this->tablename . '.status', $this->quoteIdentifier($this->invoicestatusTablename . '.uid'))
            );
            $this->invoicestatusJoined = true;
        }
    }
    public function addSearch($search)
    {
        $constraints = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constraints[] = $this->expr()->eq(
                $this->tablename . '.uid',
                $this->createNamedParameter(trim((string) $search['uid']), Connection::PARAM_INT)
            );
        }
        if (isset($search['uids']) && $search['uids'] !== '') {
            $uids = GeneralUtility::intExplode(',', $search['uids'], true);
            $constraints[] = $this->expr()->in(
                $this->tablename . '.uid',
                $this->createNamedParameter($uids, Connection::PARAM_INT_ARRAY)
            );
        }
        if (isset($search['status']) && $search['status'] !== '') {
            if (is_array($search['status'])) {
                $constraints[] = $this->expr()->in(
                    'status',
                    $this->createNamedParameter($search['status'], Connection::PARAM_INT_ARRAY)
                );
            } elseif (is_string($search['status']) && str_contains($search['status'], ',')) {
                $constraints[] = $this->expr()->in(
                    'status',
                    $this->createNamedParameter(GeneralUtility::intExplode(
                        ',',
                        $search['status'],
                        true
                    ), Connection::PARAM_INT_ARRAY)
                );
            } else {
                $constraints[] = $this->expr()->eq(
                    'status',
                    $this->createNamedParameter($search['status'], Connection::PARAM_INT)
                );
            }
        }
        if (isset($search['isFinished']) && $search['isFinished'] !== '') {
            $this->joinInvoicestatus();
            $constraints[] = $this->expr()->eq('is_finished', (int)$search['isFinished']);
        }
        if (isset($search['isPaid']) && $search['isPaid'] !== '') {
            $this->joinInvoicestatus();
            $constraints[] = $this->expr()->eq('is_paid', (int)$search['isPaid']);
        }
        if (isset($search['isPaidOrNotFinished']) && $search['isPaidOrNotFinished'] == 1) {
            $this->joinInvoicestatus();
            $constraints[] = $this->expr()->or($this->expr()
->eq('is_finished', 0), $this->expr()
->eq('is_paid', 1));
        }
        if (isset($search['isDraft']) && $search['isDraft'] !== '') {
            $this->joinInvoicestatus();
            $constraints[] = $this->expr()->eq('is_draft', (int)$search['isDraft']);
        }
        
        if (isset($search['verband']) && $search['verband'] !== '') {
            $constraints[] = $this->expr()->eq('verband_id', (int) $search['verband']);
        }

        if (isset($search['createDateFrom']['date']) && $search['createDateFrom']['date'] !== '') {
            $constraints[] = $this->expr()->gte(
                'create_date',
                $this->createNamedParameter($search['createDateFrom']['date'])
            );
        }
        if (isset($search['createDateTo']['date']) && $search['createDateTo']['date'] !== '') {
            $constraints[] = $this->expr()->lte(
                'create_date',
                $this->createNamedParameter($search['createDateTo']['date'])
            );
        }
        if (isset($search['paidDateFrom']['date']) && $search['paidDateFrom']['date'] !== '') {
            $constraints[] = $this->expr()->gte(
                'paid_date',
                $this->createNamedParameter($search['paidDateFrom']['date'])
            );
        }
        if (isset($search['paidDateTo']['date']) && $search['paidDateTo']['date'] !== '') {
            $constraints[] = $this->expr()->lte(
                'paid_date',
                $this->createNamedParameter($search['paidDateTo']['date'])
            );
        }

        $hasBookFrom = (isset($search['bookFrom']['date']) && $search['bookFrom']['date'] !== '');
        $hasBookTo = (isset($search['bookTo']['date']) && $search['bookTo']['date'] !== '');
        if ($hasBookFrom || $hasBookTo) {
            $subselectWhere = [];
            if ($hasBookFrom) {
                $subselectWhere[] = 'DATE(booking_date) >= ' . $this->createNamedParameter($search['bookFrom']['date']);
            }
            if ($hasBookTo) {
                $subselectWhere[] = 'DATE(booking_date) <= ' . $this->createNamedParameter($search['bookTo']['date']);
            }
            $constraints[] = $this->tablename . '.uid IN (SELECT invoice FROM ' . $this->invoicepaymentTablename . ' WHERE  ' . implode(
                ' AND ',
                $subselectWhere
            ) . ')';
        }

        
        if (isset($search['ids']) && $search['ids'] !== '') {
            $ids = GeneralUtility::intExplode(',', $search['ids'], true);
            if (!empty($ids)) {
                $constraints[] = $this->expr()->in(
                    $this->tablename . '.uid',
                    $this->createNamedParameter($ids, Connection::PARAM_INT_ARRAY)
                );
            }
        }

        $constraints = $this->addEqualRangeConstrain($constraints, 'total', $search['total'] ?? null);


        $constraints = $this->addRawEqualRangeConstrain(
            $constraints,
            'total - amount_paid - pre_payment_credit_amount',
            $search['amountOpen'] ?? null
        );
        $constraints = $this->addEqualRangeConstrain($constraints, 'amount_paid', $search['amountPaid'] ?? null);

        if (isset($search['deliveryMethod']) && $search['deliveryMethod'] !== '') {
            $deliveryMethods = $this->debitorService->getEntryDeliveryMethods();

            if ($search['deliveryMethod'] == 'mail') {
                // Rechnung fuer E-Mail Versand
                // E-Mail only for status: Entwurf, Verschickt, Mahnung
                if ($deliveryMethods['mail'] ?? false) {
                    $constraints[] = $deliveryMethods['mail'];
                }

                //$constraints[] = '(status IN (' . implode(',', $this->deliveryMethodStatusIds) . ')' . (isset($deliveryMethods['mail'])  ? ' AND ' . $deliveryMethods['mail'] : ''). ')';
            } elseif ($search['deliveryMethod'] == 'print') {
                // Rechnung fuer Ausdruck/Brief
                if ($deliveryMethods['print'] ?? false) {
                    $constraints[] = $deliveryMethods['print'];
                }
                //$constraints[] = '(status NOT IN (' . implode(',', $this->deliveryMethodStatusIds) . ')' . ($deliveryMethods['print'] ? ' OR ' . $deliveryMethods['print'] : '') . ')';
            }
        }
        if (isset($search['tablenames']) && $search['tablenames'] !== '') {
            $constraints[] = $this->expr()->eq('tablenames', $this->createNamedParameter($search['tablenames']));
        }
        if (isset($search['invoice']) && $search['invoice'] !== '') {
            $constraints[] = $this->expr()->eq(
                'invoice',
                $this->createNamedParameter($search['invoice'], Connection::PARAM_INT)
            );
        }
        if (isset($search['uidFrom']) && $search['uidFrom'] !== '') {
            $constraints[] = $this->expr()->gte(
                $this->tablename . '.uid',
                $this->createNamedParameter(trim((string) $search['uidFrom']), Connection::PARAM_INT)
            );
        }
        if (isset($search['uidTo']) && $search['uidTo'] !== '') {
            $constraints[] = $this->expr()->lte(
                $this->tablename . '.uid',
                $this->createNamedParameter(trim((string) $search['uidTo']), Connection::PARAM_INT)
            );
        }
        // Use Contacts/Entries stuff
        if ($this->entryTablename !== null) {
            if (isset($search['entryType']) && $search['entryType'] !== '') {
                $constraints[] = $this->expr()->eq(
                    $this->entryTablename . '.type',
                    $this->createNamedParameter($search['entryType'])
                );
            }
            if (isset($search['entryUid']) && $search['entryUid'] !== '') {
                $constraints[] = $this->expr()->eq(
                    $this->entryTablename . '.' . $this->entryPrimaryKey,
                    $this->createNamedParameter($search['entryUid'], Connection::PARAM_INT)
                );
            }
            $languageAttribute = $this->debitorService->getLanguageAttribute();
            if ($languageAttribute !== null && isset($search['language']) && $search['language'] !== '') {
                $constraints[] = $this->expr()->eq(
                    $languageAttribute,
                    $this->createNamedParameter($search['language'], Connection::PARAM_INT)
                );
            }
            // @todo re_betrieb in pedos ("concat" form config)
            if (isset($search['entryNumber']) && $search['entryNumber'] !== '') {
                $entryNumberName = $this->debitorService->getEntryNumberName();
                //$constraints[] = "concat(bet_k,bet_b,bet_a) LIKE " . $this->createNamedParameter($search['entryNumber'] .'%');
                $constraints[] = $entryNumberName . ' LIKE ' . $this->createNamedParameter(
                    $search['entryNumber'] . '%'
                );
            }
            $languageAttribute = $this->debitorService->getLanguageAttribute();
            if ($languageAttribute !== null && isset($search['language']) && $search['language'] !== '') {
                $constraints[] = $this->expr()->eq(
                    $languageAttribute,
                    $this->createNamedParameter($search['language'], Connection::PARAM_INT)
                );
            }
            if (isset($search['keyword']) && $search['keyword'] !== '') {
                // Personen sub search
                $keywordsArray = GeneralUtility::trimExplode(' ', $search['keyword'], true);
                $entryKeywordSearchAttributes = $this->debitorService->getKeywordSearchAttributes();
                if (!empty($keywordsArray) && !empty($entryKeywordSearchAttributes)) {
                    foreach ($keywordsArray as $keyword) {
                        $subConstraints = [];
                        foreach ($entryKeywordSearchAttributes as $type => $attribute) {
                            if ($type == 'concat') {
                                $concatAttributes = GeneralUtility::trimExplode(',', $attribute, true);
                                $concat = [];
                                foreach ($concatAttributes as $concatAttribute) {
                                    if (str_starts_with($concatAttribute, '\'')) {
                                        $concatAttribute = trim($concatAttribute, '\'');
                                        $concat[] = $this->createNamedParameter($concatAttribute);
                                    } else {
                                        $concat[] = $this->quoteIdentifier($concatAttribute);
                                    }
                                }
                                $subConstraints[] = 'concat(' . implode(
                                    ',',
                                    $concat
                                ) . ') LIKE ' . $this->createNamedParameter('%' . $keyword . '%');
                                /*
                                  // risky and probably we don't want that
                                  } elseif ($type == 'function') {
                                $subConstraints[] = $attribute . ' LIKE ' . $this->createNamedParameter('%' . $keyword . '%');
                                */
                            } else {
                                $subConstraints[] = $this->expr()->like(
                                    $attribute,
                                    $this->createNamedParameter('%' . $keyword . '%')
                                );
                            }
                        }
                        $subConstraints[] = $this->expr()->eq(
                            $this->tablename . '.uid',
                            $this->createNamedParameter($keyword, Connection::PARAM_INT)
                        );
                        $constraints[] = $this->expr()->or(...$subConstraints);
                    }
                }
                //$constraints[] = $this->expr()->eq($this->entryTablename . '.uid', $this->quoteIdentifier('entry_id'));
            }


            if (isset($search['sammelinvoice']) && $search['sammelinvoice'] !== '') {
                $constraints[] = $this->expr()->eq(
                    $this->entryTablename . '.me_is_sammelinvoice',
                    $search['sammelinvoice'] ? 1 : 0
                );
            }
        }
        if (isset($search['periode']) && $search['periode'] !== '') {
            //$constraints[] = $this->expr()->eq('periode', $this->createNamedParameter($search['periode']));
            //$constraints[] = '(tx_igfibu_domain_model_invoice.periode = ' . $this->createNamedParameter($search['periode']) . ' OR EXISTS (SELECT 1 FROM tx_igfibu_domain_model_invoiceitem WHERE invoice=tx_igfibu_domain_model_invoice.uid AND tx_igfibu_domain_model_invoiceitem.deleted=0 AND period=' . (int)$search['periode'] . '))';
            $constraints[] = '(tx_igfibu_domain_model_invoice.periode = ' . $this->createNamedParameter(
                $search['periode']
            ) . ' OR tx_igfibu_domain_model_invoice.uid IN (SELECT invoice FROM tx_igfibu_domain_model_invoiceitem WHERE tx_igfibu_domain_model_invoiceitem.deleted=0 AND period=' . $this->createNamedParameter(
                $search['periode']
            ) . '))';
        }

        if (isset($search['costCenter']) && $search['costCenter'] !== '') {
            //$constraints[] = 'EXISTS (SELECT 1 FROM tx_igfibu_domain_model_invoiceitem WHERE invoice=tx_igfibu_domain_model_invoice.uid AND tx_igfibu_domain_model_invoiceitem.deleted=0 AND cost_center=' . (int)$search['costCenter'] . ')';
            $constraints[] = 'tx_igfibu_domain_model_invoice.uid IN (SELECT invoice FROM tx_igfibu_domain_model_invoiceitem WHERE tx_igfibu_domain_model_invoiceitem.deleted=0 AND cost_center=' . (int)$search['costCenter'] . ')';
        }


        if (isset($search['contactVerbandMembership']) && $search['contactVerbandMembership'] !== '' && $search['verband']) {
            //var_dump($search['contactVerband']);exit(0);
            //$constraints[] = $this->expr()->eq('mitgliedschaft', $this->createNamedParameter($search['contactVerbandMembership'], \Connection::PARAM_INT));
            $constraints[] = '(tx_igfibu_domain_model_invoice.mitgliedschaft = ' . $this->createNamedParameter(
                $search['contactVerbandMembership'],
                Connection::PARAM_INT
            ) . ' OR tx_igfibu_domain_model_invoice.uid IN (SELECT invoice FROM tx_igfibu_domain_model_invoiceitem WHERE tx_igfibu_domain_model_invoiceitem.deleted=0 AND membership=' . $this->createNamedParameter(
                $search['contactVerbandMembership'],
                Connection::PARAM_INT
            ) . '))';
        }
        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
}
