<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

class PaymentImportQueryBuilder extends BaseQueryBuilder
{
    protected $tablename = 'tx_igfibu_domain_model_paymentimport';

    public function addSearch($search)
    {
        $constraints = [];

        if (isset($search['uid']) && $search['uid'] !== '') {
            $constraints[] = $this->expr()->eq($this->tablename . '.uid', trim((string) $search['uid']));
        }
        if (isset($search['verband']) && $search['verband'] !== '') {
            $constraints[] = $this->expr()->eq('verband_id', $search['verband']);
        }

        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
}
