<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * Credit
 */
class MasterCredit extends AbstractEntity implements FibuAclInterface
{
    /**
     * tenantId
     *
     * @var int
     */
    protected $tenantId = 0;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * amount
     */
    protected ?float $amount = null;

    /**
     * dueDate
     *
     * @var DateTime
     */
    protected $dueDate = null;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the amount
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * Sets the amount
     */
    public function setAmount(?float $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns the dueDate
     *
     * @return DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * Sets the dueDate
     */
    public function setDueDate(DateTime $dueDate = null): void
    {
        $this->dueDate = $dueDate;
    }


    /**
     * Returns the tenantId
     */
    public function getTenantId(): ?int
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }
}
