<?php

namespace Ig\IgFibu\Domain\Repository;

use Ig\IgFibu\Database\Query\LogMailQueryBuilder;
use Internetgalerie\IgDoctrinePaginator\Pagination\DoctrinePaginator;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for LogMail
 */
class LogMailRepository extends BaseRepository
{
    protected static $tablename = 'tx_igfibu_domain_model_log_mail';
    protected static $queryBuilderClass = LogMailQueryBuilder::class;
    protected static $localDebitorAttribute = 'entry_id';
    protected static $localClientAttribute = 'verband_id';
    protected static $localTypeAttribute = null;
    protected static $llocalTablenamesAttribute = null;
    protected static $modelClass = LogMail::class;
    protected $defaultOrderings = [
        'uid' => QueryInterface::ORDER_DESCENDING,
    ];

    /**
     * insert a mail to log
     */
    public function insertInvoice(string $mailTo, array $conf): int
    {
        $vals = [
            //                     'create_date' => 'CURRENT_TIMESTAMP',
            'lm_mail_to' => $mailTo,
            'verband_id' => $conf['verband_uid'],
            'entry_id' => $conf['debitor']->getUid(),
            'entry_ids' => implode(',', $conf['entry_ids']),
            'lm_re_betrag_ez' => $conf['betrag_ez'],
            'lm_invoice_re_id' => $conf['invoice_uid'],
            'lm_invoice_count' => count($conf['invoices']),
            'lm_periode_name' => $conf['periode_name'],
            'lm_subject' => $conf['subject'],
            'lm_language' => $conf['crm_language'],
        ];

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            static::$tablename
        );
        $queryBuilder->insert(static::$tablename)->values($vals)->executeStatement();
        $conn = $queryBuilder->getConnection();
        return $conn->lastInsertId();
    }
    /**
     * get querybuilder joined with debitor table and search where added
     */
    public function getQueryBuilderBySearch(array $search = [], array $orderings = [])
    {
        $queryBuilder = $this->createQueryBuilderLeftJoinEntries();
        $queryBuilder->select(static::$tablename . '.*');
        $queryBuilder->addSearch($search);
        $queryBuilder->addUserRestriction();
        $this->queryBuilderAddDefaulSorting($queryBuilder);
        return $queryBuilder;
    }
    /**
     * add invoices and debitor to raw query results
     */
    public function proccessResult(array $items)
    {
        $logMails = [];
        foreach ($items as $item) {
            $logMail = $item;
            $logMail['debitor'] = $this->debitorService->getDebitorById($item['entry_id']);
            $invoices = [];
            $ids = GeneralUtility::trimExplode(',', $item['lm_invoice_re_id']);
            $betraege = GeneralUtility::trimExplode(',', $item['lm_re_betrag_ez']);
            for ($i = 0; $i < count($ids) && $i < 100; $i++) {
                $invoices[$ids[$i]] = [
                    'uid' => $ids[$i],
                    'total' => $betraege[$i],
                ];
            }
            ksort($invoices);
            $logMail['invoices'] = $invoices;
            $logMails[] = $logMail;
        }

        return $logMails;
    }
    /**
     * expand paginatedItems with infos (invoices and debitor)
     */
    public function paginationProccessResult(DoctrinePaginator $pagination): void
    {
        $paginatedItems = $pagination->getPaginatedItems();
        $paginatedItems = $this->proccessResult($paginatedItems);
        $pagination->setPaginatedItems($paginatedItems);
    }

    public function findStatistikYearMonth(array $verbandsUids, array $search = [])
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(static::$tablename);

        $sqlSelect = "DATE_FORMAT(create_date,'%Y-%m') AS sendDate,SUM(1) AS anzahl,SUM(lm_re_betrag_ez) AS totalBetragEz,sum(lm_invoice_count) AS anzahlInvoices,GROUP_CONCAT(lm_invoice_re_id) AS invoicesIds";

        // @todo remove - test mails are not logged
        /*
        $excludeMails = [
            'pedosnet@pedos.ch',
            'info@pedos.ch',
            'da@summer.ch',
        ];
        $sqlWhere ='';
        if (!empty($excludeMails)) {
            $sqlWhere = "lm_mail_to NOT IN ('" . implode("', '", $excludeMails) . "')";
            $sqlWhere .= static::andVerband($verbandsUids, $search);
        } else {
            $sqlWhere .= static::andVerband($verbandsUids, $search, '');
        }
        */
        $sqlWhere = static::andVerband($verbandsUids, $search, '');
        $sqlGroupBy = "DATE_FORMAT(create_date,'%Y-%m')";

        $sql = 'SELECT ' . $sqlSelect . ' FROM ' . static::$tablename . ' WHERE ' . $sqlWhere . '  GROUP BY ' . $sqlGroupBy . ' ORDER BY  sendDate DESC';
        $stmt = $conn->prepare($sql);
        $result = $stmt->executeQuery();
        return $result->fetchAllAssociative();
    }
}
