<?php

namespace Ig\IgFibu\Domain\Repository;

use TYPO3\CMS\Core\Database\Connection;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * The repository for MailQueue
 */
class MailQueueRepository //extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    protected $tablename = 'tx_igfibu_domain_model_mailqueue';

    //public function add(array $invoiceUids, int $mandantId = null)
    public function add(array $email)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $values = [
            'invoice' => $email['invoice_uid'],
            'verband_id' => $email['verband_uid'],
        ];
        // createdate = now
        // hasError = false

        $affectedRows = $queryBuilder->insert($this->tablename)
->values($values)
->executeStatement();
        $conn = $queryBuilder->getConnection();
        return $conn->lastInsertId();
    }

    public function findAll(int $mandantId = null, int $maxResults = null)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $queryBuilder
            ->select('uid', 'invoice')
->from($this->tablename)
->where(
    $queryBuilder->expr() ->eq('verband_id', $queryBuilder->createNamedParameter($mandantId, Connection::PARAM_INT))
)
            ->orderBy('uid', 'DESC');
        if ($maxResults !== null) {
            $queryBuilder->setMaxResults($maxResults);
        }
        $res = $queryBuilder->executeQuery();
        return $res;
        /*
        $ret = [];
        while ($row =$res->fetchAssociative()) {
            $ret[] = $row;
        }
        return $ret;
        */
    }

    public function delete(int $uid): void
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        $result = $queryBuilder->delete($this->tablename)
->where($queryBuilder->expr() ->equals('uid', $uid))
->executeStatement();
    }
}
