<?php

namespace Ig\IgFibu\Domain\Repository;

use Ig\IgFibu\Database\Query\PaymentImportQueryBuilder;
use Ig\IgFibu\Domain\Model\PaymentImport;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for PaymentImports
 */
class PaymentImportRepository extends BaseRepository
{
    protected static $tablename = 'tx_igfibu_domain_model_paymentimport';
    protected static $queryBuilderClass = PaymentImportQueryBuilder::class;
    protected static $localDebitorAttribute = null;
    protected static $localClientAttribute = null;
    protected $entryTablename = null;
    protected $entryPrimaryKey = null;

    protected $defaultOrderings = [
        'create_date' => QueryInterface::ORDER_DESCENDING,
        'uid' => QueryInterface::ORDER_DESCENDING,
    ];

    public function findLast(array $search)
    {
        $queryBuilder = $this->createQueryBuilder();
        $queryBuilder->addSearch($search);

        $queryBuilder
            ->from(static::$tablename)
            //->selectLiteral('sum(total) as total_inkl')
            ->selectLiteral('*')
            ->orderBy('uid', 'DESC')
            ->setMaxResults(1);
        $res = $queryBuilder->executeQuery();
        return $res->fetchAssociative();
    }
    /*
    public function findBySearch(array $search, bool $returnRawQueryResult = false)
    {
        $query = $this->createQuery();
        if ($search['verband'] ?? false) {
            $query->matching(
                $query->equals('verbandId', (int)$search['verband'])
            );
        }
        return $query->execute($returnRawQueryResult);
    }
     */
    public function findByInfo(array $info, ?int $tenantId): ?PaymentImport
    {
        $query = $this->createQuery();
        $constraints = [];
        if ($tenantId !== null) {
            $constraints[] = $query->equals('verbandId', (int)$tenantId);
        }
        $orConstraints = [];
        if ($info['msgId']) {
            $orConstraints[] = $query->equals('msgId', $info['msgId']);
        }
        if ($info['ntfctn']['id']) {
            $orConstraints[] = $query->equals('ntfctnId', $info['ntfctn']['id']);
        }
        if (!empty($orConstraints)) {
            $constraints[] = $query->logicalOr(...$orConstraints);
        }
        if (empty($constraints)) {
            return null;
        }
        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute()
->getFirst();
    }
}
