<?php

namespace Ig\IgFibu\Event;

use Ig\IgFibu\Domain\Model\Invoice;
use Psr\EventDispatcher\StoppableEventInterface;

final class SubtotalEvent implements StoppableEventInterface
{
    public function __construct(
        private Invoice $invoice,
        private readonly bool $isExcludingTax,
        private float $totalTax
    ) {
    }
 
    public function getInvoice(): Invoice
    {
        return $this->invoice;
    }
 
    public function setInvoice(Invoice $invoice): void
    {
        $this->invoice = $invoice;
    }
    public function getIsExcludingTax(): bool
    {
        return $this->isExcludingTax;
    }
    public function getTotalTax(): float
    {
        return $this->totalTax;
    }
 
    public function setTotalTax(float $totalTax): void
    {
        $this->totalTax = $totalTax;
    }


    public function isPropagationStopped(): bool
    {
        return false;
    }
}
