<?php

namespace Ig\IgFibu\ReferenceFormatter;

use Ig\IgFibu\Service\DebitorService;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class DefaultReferenceFormatter extends AbstractReferenceFormatter
{
    /**
     * priority - higher comes first
     */
    public int $priority = 1;
    protected $referenceBankLength = 6; //ESR-Identifikationsnummer des Kunden bei der Bank
    protected $referenceRFLength = 4; //RF + checksum from QrBill\Reference\RfCreditorReferenceGenerator::generate
    protected $referenceUserFormatLength = 2; // Interne Nummer um Verschiedene Referenz Muster zu unterstützen
    protected $referenceUserEntryIdLength = 7; // Debitor Number
    protected $referenceUserInvoiceIdLength = 11; // invoice Number
    
    protected string $referenceFormat = '00';

    protected $debitorService = null;
    
    public function canConvert(string $reference, ?int $tenantId): bool
    {
        // RF
        if (str_starts_with($reference, 'RF')) {
            // 2 RF + 2 from RfCreditorReferenceGenerator
            return substr(
                $reference,
                $this->referenceRFLength,
                strlen($this->referenceFormat)
            ) == $this->referenceFormat;
        }
        return substr($reference, $this->referenceBankLength, strlen($this->referenceFormat)) == $this->referenceFormat;
    }
    
    /**
     * Actually convert reference
     */
    public function convert(string $reference, ?int $tenantId): ReferenceFormatterResult
    {
        // RF
        if (str_starts_with($reference, 'RF')) {
            // 2 (RF) + 2 from QrBill\Reference\RfCreditorReferenceGenerator::generate
            $referenceId = substr($reference, $this->referenceRFLength);
            $referenceLenght = strlen($reference);
            $start = 0;
            // allow a extra 0
            if ($referenceLenght == 25) {
                $start++;
            }
            $referenceFormat = substr($referenceId, $start, $this->referenceUserFormatLength);
            $start += $this->referenceUserFormatLength;
            
            $referenceEntry = substr($referenceId, $start, $this->referenceUserEntryIdLength);
            $start += $this->referenceUserEntryIdLength;

            // checksum is at start -> no -1
            $referenceInvoice = substr($referenceId, $start, strlen($referenceId) - $start);
            $length = 4 + $this->referenceUserFormatLength + $this->referenceUserEntryIdLength + $this->referenceUserInvoiceIdLength;
            //echo('F: ' . strlen($referenceFormat) . ', E='. strlen($referenceEntry) . ', I='. strlen($referenceInvoice) .' (TOTAL='.strlen($reference).')<br />');
            if ($length !== 24 && $length !== 25) {
                die('configuration error in EXT:ig_fibu/Classes/ReferenceFormatter/DefaultReferenceFormatter.php, length for RF References must be 24 (or 25) but is ' . $length);
            }
        } else {
            $referenceBank = substr($reference, 0, $this->referenceBankLength);
            $referenceId = substr($reference, $this->referenceBankLength);
            $start = 0;
            $referenceFormat = substr($referenceId, $start, $this->referenceUserFormatLength);
            $start += $this->referenceUserFormatLength;
            
            $referenceEntry = substr($referenceId, $start, $this->referenceUserEntryIdLength);
            $start += $this->referenceUserEntryIdLength;

            $referenceInvoice = substr($referenceId, $start, strlen($referenceId) - $start - 1);
            $length = $this->referenceBankLength + $this->referenceUserFormatLength + $this->referenceUserEntryIdLength + $this->referenceUserInvoiceIdLength + 1;
            if ($length != 27) {
                die('configuration error in EXT:ig_fibu/Classes/ReferenceFormatter/DefaultReferenceFormatter.php, length must be 27 but is ' . $length);
            }
        }


        //$tablenames = $this->getDebitorService()->getTablenamesByFormat($referenceFormat);
        
        $referenceFormatterResult = new ReferenceFormatterResult(
            (int)$referenceInvoice, // invoice UID
            (int)$referenceEntry, // Debitor UID
            $referenceFormat, // Format (optional)
        );
        $referenceFormatterResult->setReferenceDebitor($referenceEntry);
        return $referenceFormatterResult;
    }

    /**
     * get reference for swiss QR (max length: 26)
     * smaller will be left padded with 0, check digit is appended to total length of 27
     */
    public function getReference(AddressInterface $debitor, int $invoiceId): string
    {
        if (strlen($this->referenceFormat) != 2) {
            die('error: unknown referenceFormat: "' . $this->referenceFormat . '"');
        }
        // Referenzart
        $reference = $this->referenceFormat;

        $debitorNumber = $debitor->getUid();
        
        //  Referenznummer Kunde 7 Stellen
        $reference .= str_pad($debitorNumber, 7, '0', STR_PAD_LEFT);
        //  Referenznummer Rechnung 11 Stellen
        $reference .= str_pad($invoiceId, 11, '0', STR_PAD_LEFT);

        // has length 20
        return $reference;
    }


    /**
     * get RF reference (length 20), check digits are prepended
     */
    public function getRFReference(AddressInterface $debitor, int $invoiceId): string
    {
        return $this->getReference($debitor, $invoiceId);
    }


    
    /**
     * @return DebitorService
     */
    public function getDebitorService()
    {
        if ($this->debitorService === null) {
            $this->debitorService = GeneralUtility::makeInstance(DebitorService::class);
        }
        return $this->debitorService;
    }
}
