<?php

namespace Ig\IgFibu\Utility;

use Ig\IgFibu\Service\Period\AbstractPeriodService;
use Ig\IgFibu\Service\Period\MonthPeriodService;
use Ig\IgFibu\Service\Period\QuarterPeriodService;
use Ig\IgFibu\Service\Period\YearPeriodService;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PeriodUtility implements SingletonInterface
{
    protected $periodServices = [
        [
            'name' => 'Jahr',
            'durationInMonth' => 12,
            'class' => YearPeriodService::class,
        ],
        [
            'name' => 'Quartal',
            'durationInMonth' => 3,
            'class' => QuarterPeriodService::class,
        ],
        [
            'name' => 'Monat',
            'durationInMonth' => 1,
            'class' => MonthPeriodService::class,
        ],
    ];
    
    /**
     * get the PeriodService for $durationInMonth
     */
    public function getPeriodServiceByDuration(int $durationInMonth): AbstractPeriodService
    {
        if ($durationInMonth == 12) {
            return GeneralUtility::makeInstance(YearPeriodService::class);
        } elseif ($durationInMonth == 3) {
            return GeneralUtility::makeInstance(QuarterPeriodService::class);
        }
        $periodService = GeneralUtility::makeInstance(MonthPeriodService::class);
        $periodService->setDurationInMonth($durationInMonth);
        return $periodService;
    }

    /**
     * get all register PeriodServices
     */
    public function getAll(): array
    {
        return $this->periodServices;
    }
}
