<?php

namespace Ig\IgFibu\ViewHelpers\Debitor;

use Ig\IgFibu\Service\DebitorService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class LinkViewHelper extends AbstractTagBasedViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * @var string
     */
    protected $tagName = 'a';

    public function initializeArguments(): void
    {
        $this->registerArgument('action', 'string', 'action', false, 'show');
        $this->registerArgument('debitor', 'mixed', 'debitor', true);
        $this->registerArgument('type', 'string', 'debitor type', false, 'auto');
        $this->registerArgument('tenant', 'int', 'tenant mandant', false, 1);
        $this->registerArgument('title', 'string', 'title', false);
        //$this->registerArgument('arguments', 'array', 'array', false, []);
    }

    /**
     * Render a link
     *
     * @return string
     * @api
     */
    public function render()
    {
        $request = $this->renderingContext->getRequest();
        //$arguments= $request->getArguments();
        $action = $this->arguments['action'];

        $debitor = $this->arguments['debitor'];
        if (is_object($debitor)) {
            $debitorId = $debitor->getUid();
            $type = $debitor->getType();
        } else {
            $debitorId = (int)$debitor;
            $type = $this->arguments['type'];
        }
        $tenant = (int)$this->arguments['tenant'];
        $debitorService = GeneralUtility::makeInstance(DebitorService::class);
        $uri = $debitorService->getUriByDebitorId($request, $action, $type, $debitorId, $tenant);
        if ($this->arguments['label'] ?? false) {
            $this->tag->addAttribute('label', $this->arguments['label']);
        }
        $content = $this->renderChildren();
        //$this->tag->addAttribute('class', $class);
        $this->tag->addAttribute('href', $uri);
        $this->tag->addAttribute('title', $this->arguments['title'] ?? '');
        $this->tag->setContent($content);
        $this->tag->forceClosingTag(true);
        return $this->tag->render();
    }
}
