<?php

namespace Ig\IgFibu\ViewHelpers\Invoice;

use Closure;
use Ig\IgFibu\Domain\Model\Invoice;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ItemViewHelper extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('invoice', Invoice::class, 'invoice to get items', true);
        $this->registerArgument('costcenterCode', 'string', 'find by costCenter code', false);
        $this->registerArgument('as', 'string', 'name of invoiceItem', true);
    }

    public function render(): string
    {
        $invoice = $this->arguments['invoice'];
        $costcenterCode = $this->arguments['costcenterCode'];
        $invoiceitems = $invoice->getInvoiceItems();
        $costcenter = null;
        $as = null;
        if (!empty($invoiceitems)) {
            foreach ($invoiceitems as $invoiceitem) {
                $itemCostcenter = $invoiceitem->getCostCenter();
                if ($itemCostcenter && $itemCostcenter->getCode() == $costcenterCode) {
                    $costcenter = $itemCostcenter;
                    $as = $invoiceitem;
                    break;
                }
            }
        }
        $templateVariableContainer = $renderingContext->getVariableProvider();
        // $templateVariableContainer=$renderingContext->getTemplateVariableContainer(); bis 8.7
        $templateVariableContainer->add($this->arguments['as'], $as);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
