<?php

namespace Ig\IgFibu\ViewHelpers\Period;

use Closure;
use Ig\IgFibu\Domain\Model\ClientInterface;
use Ig\IgFibu\Utility\PeriodUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class LabelViewHelper extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;
    protected static $periodUtility = null;
    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'string', 'period value', true);
        $this->registerArgument('tenant', ClientInterface::class, 'client interface', true);
    }

        public function render(): string
    {
        $periodValue = $this->arguments['value'];
        $tenant = $this->arguments['tenant'];

        $periodUtility = static::getPeriodUtility();
        $periodService = $periodUtility->getPeriodServiceByDuration($tenant->getInvoicePeriodeLengthInMonth() ?? 12);
        $periodDate = $periodService->createByValue($periodValue);
        return $periodService->getLabel($periodDate);
    }

    public static function getPeriodUtility()
    {
        if (static::$periodUtility === null) {
            static::$periodUtility = GeneralUtility::makeInstance(PeriodUtility::class);
        }
        return static::$periodUtility;
    }
}
