<?php

namespace Ig\IgFibu\ViewHelpers;

use Closure;
use Ig\IgFibu\Domain\Model\Invoice;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TemplateViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('invoice', Invoice::class, 'Invoice', true);
        $this->registerArgument('objectType', 'string', 'objectType', true);
        $this->registerArgument('as', 'string', 'as', true);
    }

    public function render(): string
    {
        die('TemplateViewHelper.php: change  fibu.template to cg:template');
        $invoice = $this->arguments['invoice'];
        $template = $invoice->getVerbandTemplate($this->arguments['objectType']);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        // $templateVariableContainer=$renderingContext->getTemplateVariableContainer(); bis 8.7
        $templateVariableContainer->add($this->arguments['as'], $template);
        $output = $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
