<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Ig\IgFibu\Controller\InvoiceController;
use Ig\IgFibu\Controller\InvoiceItemController;
use Ig\IgFibu\Controller\LogMailController;
use Ig\IgFibu\Controller\PaymentController;
use Ig\IgFibu\Controller\PaymentImportController;
use Ig\IgFibu\Controller\InvoicePaymentController;
use Ig\IgFibu\Controller\CreditController;
use Ig\IgFibu\Controller\FibuStatistikController;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;
use Ig\IgFibu\Utility\InvoiceUtility;
use Ig\IgFibu\ReferenceFormatter\DefaultReferenceFormatter;

defined('TYPO3') or die();

call_user_func(
    function()
    {
        $GLOBALS['TYPO3_CONF_VARS']['MAIL']['layoutRootPaths'][4564] = 'EXT:ig_fibu/Resources/Private/Email/Layouts/';
        $GLOBALS['TYPO3_CONF_VARS']['MAIL']['templateRootPaths'][4564] = 'EXT:ig_fibu/Resources/Private/Email/Templates/';
        $GLOBALS['TYPO3_CONF_VARS']['MAIL']['partialRootPaths'][4564] = 'EXT:ig_fibu/Resources/Private/Email/Partials/';



$GLOBALS['TYPO3_CONF_VARS']['SYS']['fluid']['namespaces']['fibu'] = [
    'Ig\IgFibu\ViewHelpers',
];


        ExtensionUtility::configurePlugin(
            'IgFibu',
            'Re',
            [
                InvoiceController::class => 'list, show, sorting, printPreview, printHtml, printPdf, ajaxPdf, ajaxSetSend, invoicePrint, invoicePrintHtml, edit, editAddress, new, addPayment, book, confirmDelete, delete, create, update, multipleEdit, multipleDelete, calculate, showSendmailList, sendmailList, importFormUpload, ajaxUpload, importFormConfig, import, export',
                InvoiceItemController::class => 'new, newConfig, create, edit, update, delete',
                LogMailController::class => 'list'
            ],
            // non-cacheable actions
            [
                InvoiceController::class=> 'list, show, sorting, printPreview, printHtml, printPdf, ajaxPdf, ajaxSetSend, invoicePrint, invoicePrintHtml, edit, editAddress, addPayment, book, confirmDelete, delete, create, update, multipleEdit, multipleDelete, calculate, showSendmailList, sendmailList, importFormUpload, ajaxUpload, importFormConfig, import, export',
                InvoiceItemController::class => 'new, newConfig, create, edit, update, delete',
                LogMailController::class => 'list'
            ]
        );

        ExtensionUtility::configurePlugin(
            'IgFibu',
            'Za',
            [
                PaymentController::class => 'list, show, upload, book, bookAll, edit, update, new, create, delete, multipleDelete',
                PaymentImportController::class => 'list, show, showXmlFile',
                InvoicePaymentController::class => 'unbook',
            ],
            // non-cacheable actions
            [
                PaymentController::class => 'list, show, upload, book, bookAll edit, update, new, create, delete, multipleDelete',
                PaymentImportController::class => 'list, show, showXmlFile',
                InvoicePaymentController::class => 'unbook',
            ]
        );

        ExtensionUtility::configurePlugin(
            'IgFibu',
            'Credit',
            [
                CreditController::class => 'list, show, edit, update, new, create, delete, createWithPayment, createWithInvoice, book, bookForm, bookOpen',
            ],
            // non-cacheable actions
            [
                CreditController::class => 'list, show, edit, update, new, create, delete, createWithPayment, createWithInvoice, book, bookForm, bookOpen',
            ]
        );

        ExtensionUtility::configurePlugin(
            'IgFibu',
            'Stat',
            [
                FibuStatistikController::class => 'overview'
            ],
            // non-cacheable actions
            [
                FibuStatistikController::class => 'overview'
            ]
        );

        ExtensionUtility::configurePlugin(
            'IgFibu',
            'Dashboard',
            [
                FibuStatistikController::class => 'dashboard, overview'
            ],
            // non-cacheable actions
            [
                FibuStatistikController::class => 'dashboard, overview'
            ]
        );



        // wizards
        /*
        \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    re {
                        iconIdentifier = ig_fibu-plugin-re
                        title = LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_ig_fibu_re.name
                        description = LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_ig_fibu_re.description
                        tt_content_defValues {
                            CType = list
                            list_type = igfibu_re
                        }
                    }
                }
                show = *
            }
       }'
    );
        */
		$iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);

			$iconRegistry->registerIcon(
				'ig_fibu-plugin-re',
				SvgIconProvider::class,
				['source' => 'EXT:ig_fibu/Resources/Public/Icons/user_plugin_re.svg']
			);

            InvoiceUtility::registerReferenceFormatter(DefaultReferenceFormatter::class);
    }
);
