<?php

namespace Ig\IgFibu\Controller;

use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceDate;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Model\Payment;
use Ig\IgFibu\Domain\Repository\InvoiceRepository;
use Psr\Http\Message\ResponseInterface;

class InvoiceController extends AbstractInvoiceController
{
    /**
     * invoiceRepository
     *
     * @var InvoiceRepository
     */
    protected $invoiceRepository = null;


    
    public function injectInvoiceRepository(InvoiceRepository $invoiceRepository): void
    {
        $this->invoiceRepository = $invoiceRepository;
    }


    public function listAction(): ResponseInterface
    {
        return $this->initListAction();
    }

    public function showAction(Invoice $invoice): ResponseInterface
    {
        return $this->initShowAction($invoice);
    }
    public function invoicePrintHtmlAction(Invoice $invoice, InvoiceDate $invoiceDate = null): ResponseInterface
    {
        return $this->initInvoicePrintHtmlAction($invoice, $invoiceDate);
    }
    public function invoicePrintAction(Invoice $invoice, InvoiceDate $invoiceDate = null): ResponseInterface
    {
        return $this->initInvoicePrintAction($invoice, $invoiceDate);
    }
    public function createAction(Invoice $newInvoice): ResponseInterface
    {
        return $this->initCreateAction($newInvoice);
    }
    public function editAction(Invoice $invoice, array $search = []): ResponseInterface
    {
        return $this->initEditAction($invoice, $search);
    }
    public function sortingAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        return $this->initsortingAction($invoice, $invoiceItem, $search);
    }
    public function updateAction(Invoice $invoice, array $search = [], array $control = []): ResponseInterface
    {
        return $this->initUpdateAction($invoice, $search, $control);
    }
    public function deleteAction(Invoice $invoice, array $search = []): ResponseInterface
    {
        return $this->initDeleteAction($invoice);
    }
    public function multipleDeleteAction(array $multipleDelete): ResponseInterface
    {
        return $this->initMultipleDeleteAction($multipleDelete);
    }
    public function calculateAction(Invoice $invoice, string $calculate = null): ResponseInterface
    {
        return $this->initCalculateAction($invoice, $calculate);
    }
    public function bookAction(Invoice $invoice): ResponseInterface
    {
        return $this->initBookAction($invoice);
    }
    public function addPaymentAction(Invoice $invoice, Payment $payment): ResponseInterface
    {
        return $this->initAddPaymentAction($invoice, $payment);
    }
    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen an Queue anfügen (geht noch nicht)
     */
    public function addToSendmailListAction(): ResponseInterface
    {
        return $this->initAddToSendmailListAction();
    }
    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen anzeigen
     */
    public function showSendmailListAction(): ResponseInterface
    {
        return $this->initShowSendmailListAction();
    }
    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen verschicken
     */
    public function sendmailListAction(): ResponseInterface
    {
        return $this->initSendmailListAction();
    }
}
