<?php

namespace Ig\IgFibu\Controller;

use DateTime;
use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Repository\CostCenterRepository;
use Ig\IgFibu\Domain\Repository\InvoiceItemRepository;
use Ig\IgFibu\Domain\Repository\InvoiceRepository;
use Ig\IgFibu\Service\DebitorService;
use Ig\IgFibu\Utility\PeriodUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Property\TypeConverter\PersistentObjectConverter;

class InvoiceItemController extends AbstractFibuController
{
    /**
     * invoiceRepository
     *
     * @var InvoiceRepository
     */
    protected $invoiceRepository = null;

    /**
     * invoiceItemRepository
     *
     * @var InvoiceItemRepository
     */
    protected $invoiceItemRepository = null;
    
    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;

    
    public function injectInvoiceRepository(InvoiceRepository $invoiceRepository): void
    {
        $this->invoiceRepository = $invoiceRepository;
    }

    
    public function injectInvoiceItemRepository(InvoiceItemRepository $invoiceItemRepository): void
    {
        $this->invoiceItemRepository = $invoiceItemRepository;
    }

    
    public function injectDebitorService(DebitorService $debitorService): void
    {
        $this->debitorService = $debitorService;
    }


    public function initializeAction(): void
    {
        parent::initializeAction();
        $this->search = $this->getSearch();
        if ($this->arguments->hasArgument('invoiceItem')) {
            $pmc = $this->arguments->getArgument('invoiceItem')
->getPropertyMappingConfiguration();
            $pmc->setTypeConverterOption(
                PersistentObjectConverter::class,
                PersistentObjectConverter::CONFIGURATION_OVERRIDE_TARGET_TYPE_ALLOWED,
                true
            );
        }
    }

    public function newAction(Invoice $invoice, array $search = [], string $type = null): ResponseInterface
    {
        $this->view->assign('invoice', $invoice);
        //var_dump($type);exit(0);
        if ($type === null) {
            $type = InvoiceItem::class;
        }
        $invoiceItem = GeneralUtility::makeInstance($type);
        $invoiceItem->setType($type);
        //var_dump($type, $invoiceItem->getTypePartial());exit(0);
        $this->view->assign('invoiceItem', $invoiceItem);
        $this->view->assign('search', $search);
        $this->view->assign('type', $type);
        $this->assignEditFormfields($invoice, $invoiceItem);
        return $this->htmlResponse($this->view->render());
    }
    
    public function editAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        $this->view->assign('invoice', $invoice);
        $this->view->assign('invoiceItem', $invoiceItem);
        
        $this->view->assign('search', $search);
        $this->assignEditFormfields($invoice, $invoiceItem);
        return $this->htmlResponse($this->view->render());
    }
    
    public function newConfigAction(
        Invoice $invoice,
        InvoiceItem $invoiceItem,
        array $search = []
    ): ResponseInterface {
        $this->invoiceRepository->calculate($invoice);
        $invoiceItem->setLocalByInvoice($invoice);
        $invoiceItem->setSorting($invoice->getInvoiceItemsMaxSorting() + 10);
        $invoice->addInvoiceItem($invoiceItem);
        $this->view->assign('invoice', $invoice);
        $this->view->assign('invoiceItem', $invoiceItem);
        $this->view->assign('search', $search);
        $this->assignEditFormfields($invoice, $invoiceItem);
        return $this->htmlResponse($this->view->render());
        /*
        if ($invoiceItem->getIsLocalText()) {
            $this->invoiceRepository->updateAndCalculate($invoice);
            $this->redirect('show', 'Invoice', null, ['invoice' => $invoice->getUid(), 'search' => $search]);
        }
        */
    }
    
    public function createAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        //$this->invoiceItemRepository->add($invoiceItem);

        $invoiceItem->setLocalByInvoice($invoice);
        $invoiceItem->setSorting($invoice->getInvoiceItemsMaxSorting() + 10);
        $invoice->addInvoiceItem($invoiceItem);
        $this->invoiceRepository->updateAndCalculate($invoice);
        return $this->redirect('show', 'Invoice', null, [
            'invoice' => $invoice->getUid(),
            'search' => $search,
        ]);
        /*
        if ($invoiceItem->getIsLocalText()) {
            $this->redirect('show', 'Invoice', null, ['invoice' => $invoice->getUid(), 'search' => $search]);
        } else {
            $this->redirect('edit', 'InvoiceItem', null, ['invoice' => $invoice->getUid(), 'invoiceItem' => $invoiceItem->getUid(), 'search' => $search]);
        }
        */
    }

    public function updateAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        $this->invoiceItemRepository->update($invoiceItem);
        $this->invoiceRepository->updateAndCalculate($invoice);
        return $this->redirect('show', 'Invoice', null, [
            'invoice' => $invoice->getUid(),
            'search' => $search,
        ]);
    }
    
    public function deleteAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        $invoice->removeInvoiceItem($invoiceItem);
        $this->invoiceItemRepository->remove($invoiceItem);
        $this->invoiceRepository->updateAndCalculate($invoice);
        return $this->redirect('show', 'Invoice', null, [
            'invoice' => $invoice->getUid(),
            'search' => $search,
        ]);
    }

    /**
     * assign for edit/new form
     */
    public function assignEditFormfields(Invoice $invoice, InvoiceItem $invoiceItem): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_fibu/Resources/Public/JavaScript/edit_invoice.js');
        $this->view->assign('config', $this->debitorService->getAllConfig());
        $this->view->assign('mandants', $this->debitorService->getMandants());

        $costCenterRepository = GeneralUtility::makeInstance(CostCenterRepository::class);
        $costCenters = $costCenterRepository->findForVerbandGrouped($this->search['verband'] ?? null);
        $this->view->assign('costCenters', $costCenters);

        $periodUtility = GeneralUtility::makeInstance(PeriodUtility::class);
        $invoicePeriodeLengthInMonth = $invoice->getVerband()
->getInvoicePeriodeLengthInMonth() ?? 12;
        $periodService = $periodUtility->getPeriodServiceByDuration($invoicePeriodeLengthInMonth);
        $periodDates = $periodService->getRangeByCount(new DateTime(), 12, 0, true);

        if ($invoiceItem->getPeriod()) {
            $invoiceItemPeriodDate = $periodService->createByValue($invoiceItem->getPeriod());
            if (!in_array($invoiceItemPeriodDate, $periodDates)) {
                $periodDates[] = $invoiceItemPeriodDate;
            }
        }
        $periods = $periodService->getValueLabel($periodDates);
        $this->view->assign('periods', $periods);
        // assign products if available
        // @todo should be done with rest api/ajax in fluid (should be ok for less than 100 products)
        $productRepositoryClass = $this->settings['productTable']['repository'] ?? '';
        if (class_exists($productRepositoryClass)) {
            $productRepository = GeneralUtility::makeInstance($productRepositoryClass);
            $products = $productRepository->findAll();//ForVerband($this->search['verband'] ?? null);
            $this->view->assign('products', $products);
        }
    }

    protected function getSearch()
    {
        $search = [];
        if ($this->request->hasArgument('@search')) {
            $search = $this->request->getArgument('@search');
        } elseif ($this->request->hasArgument('search')) {
            $search = $this->request->getArgument('search');
        } else {
            $search = $this->searchDefault;
        }

        return $search;
    }
}
