<?php

namespace Ig\IgFibu\Controller;

use Ig\IgFibu\Domain\Model\Invoicestatus;
use Ig\IgFibu\Domain\Repository\InvoicestatusRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class InvoicestatusController extends ActionController
{
    /**
     * invoicestatusRepository
     *
     * @var InvoicestatusRepository
     */
    protected $invoicestatusRepository = null;


    
    public function injectInvoicestatusRepository(InvoicestatusRepository $invoicestatusRepository): void
    {
        $this->invoicestatusRepository = $invoicestatusRepository;
    }
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $invoicestatuses = $this->invoicestatusRepository->findAll();
        $this->view->assign('invoicestatuses', $invoicestatuses);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action show
     */
    public function showAction(Invoicestatus $invoicestatus): ResponseInterface
    {
        $this->view->assign('invoicestatus', $invoicestatus);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(Invoicestatus $newInvoicestatus): ResponseInterface
    {
        $this->addFlashMessage(
            'The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html',
            '',
            ContextualFeedbackSeverity::WARNING
        );
        $this->invoicestatusRepository->add($newInvoicestatus);
        return $this->redirect('list');
    }

    /**
     * action edit
     */
    #[IgnoreValidation([])] // $invoicestatus
    public function editAction(Invoicestatus $invoicestatus): ResponseInterface
    {
        $this->view->assign('invoicestatus', $invoicestatus);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    public function updateAction(Invoicestatus $invoicestatus): ResponseInterface
    {
        die('todo');
        $this->invoicestatusRepository->update($invoicestatus);
        return $this->redirect('list');
    }

    /**
     * action delete
     */
    public function deleteAction(Invoicestatus $invoicestatus): ResponseInterface
    {
        die('todo');
        $this->invoicestatusRepository->remove($invoicestatus);
        return $this->redirect('list');
    }
}
