<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PaymentQueryBuilder extends BaseQueryBuilder
{
    protected $tablename = 'tx_igfibu_domain_model_payment';
    protected $invoicepaymentTablename = 'tx_igfibu_domain_model_invoicepayment';
    
    public function addSearch($search)
    {
        $constraints = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constraints[] = $this->expr()->eq($this->tablename . '.uid', trim((string) $search['uid']));
        }
        if (isset($search['uids']) && $search['uids'] !== '') {
            $uids = GeneralUtility::intExplode(',', $search['uids'], true);
            $constraints[] = $this->expr()->in($this->tablename . '.uid', $uids);
        }
        if (isset($search['import']) && $search['import'] !== '') {
            $constraints[] = $this->expr()->eq('import', $search['import']);
        }
        if (isset($search['verband']) && $search['verband'] !== '') {
            $constraints[] = $this->expr()->eq('verband_id', $search['verband']);
        }
        if (isset($search['invoice']) && $search['invoice'] !== '') {
            $constraints[] = $this->expr()->eq('invoice', $search['invoice']);
        }
        if (isset($search['invoices']) && $search['invoices'] !== '') {
            $invoiceUids = GeneralUtility::intExplode(',', $search['invoices'], true);
            $constraints[] = $this->expr()->in('invoice', $invoiceUids);
        }
        if (isset($search['entryUid']) && $search['entryUid'] !== '') {
            $constraints[] = $this->expr()->eq(
                $this->tablename . '.entry_id',
                $this->createNamedParameter($search['entryUid'], Connection::PARAM_INT)
            );
        }
        if (isset($search['debitorUid']) && $search['debitorUid'] !== '') {
            $constraints[] = $this->expr()->eq(
                $this->tablename . '.debitor_id',
                $this->createNamedParameter($search['debitorUid'], Connection::PARAM_INT)
            );
        }
        $constraints = $this->addEqualRangeConstrain($constraints, 'invoice', $search['invoiceUid'] ?? null);
        $constraints = $this->addEqualRangeConstrain($constraints, 'betrag', $search['amount'] ?? null);
        $constraints = $this->addEqualRangeConstrain(
            $constraints,
            $this->tablename . '.uid',
            $search['paymentUid'] ?? null
        );
        $constraints = $this->addEqualRangeConstrain($constraints, 'charges', $search['charges'] ?? null);
        

        if (isset($search['referenceEntry']) && !empty($search['referenceEntry'])) {
            $subConstrains = [];
            foreach ($search['referenceEntry'] as $format => $entry) {
                $subConstrains[] = $this->expr()->and(
                    $this->expr()
->eq($this->tablename . '.reference_format', $this->createNamedParameter($format)),
                    //$this->expr()->eq($this->tablename . '.entry_id', (int)$this->createNamedParameter($entry, \Connection::PARAM_INT))
                    $this->expr()
->eq($this->tablename . '.reference_entry', $this->createNamedParameter($entry, Connection::PARAM_INT))
                );
            }
            $constraints[] = $this->expr()->or(...$subConstrains);
        }
        // @todo re_betrieb in pedos ("concat" form config)
        if (isset($search['entryNumber']) && $search['entryNumber'] !== '') {
            $this->entryTablename = 'betriebe';
            $this->entryPrimaryKey = 'bet_id';
            //$constraints[] = "entry_id IN (SELECT " . $this->entryPrimaryKey . " FROM " . $this->entryTablename . " WHERE concat(bet_k,bet_b,bet_a) LIKE " . $this->createNamedParameter($search['entryNumber'] .'%') . ")";
            $constraints[] = 'debitor_id IN (SELECT ' . $this->entryPrimaryKey . ' FROM ' . $this->entryTablename . ' WHERE concat(bet_k,bet_b,bet_a) LIKE ' . $this->createNamedParameter(
                $search['entryNumber'] . '%'
            ) . ')';
        }
        if (isset($search['status']) && $search['status'] !== '') {
            if ($search['status'] == 'is_ok') {
                $constraints[] = $this->expr()->eq('is_ok', 1);
            } else {
                $status = (int) $search['status'];

                if ($status > 4) {
                    // not
                    $status -= 4;
                    if ($status & 1) {
                        $constraints[] = $this->expr()->neq('is_done', 1);
                    }
                    if ($status & 2) {
                        // verbucht
                        $constraints[] = $this->expr()->neq('is_ok', 1);
                    }
                } else {
                    if ($status & 1) {
                        // Noch offen / Pendent
                        $constraints[] = $this->expr()->eq('is_done', 1);
                    } else {
                        $constraints[] = $this->expr()->eq('is_done', 0);
                    }
                    if ($status & 2) {
                        // verbucht
                        $constraints[] = $this->expr()->eq('is_ok', 1);
                    } else {
                        $constraints[] = $this->expr()->eq('is_ok', 0);
                    }
                }
            }
            /*
            elseif ($status==2) {
                // verbucht
                $constraints[] = $this->expr()->eq('isDone', true);
                $constraints[] = $this->expr()->eq('isOk', true);
            } elseif ($status==3) {
                // Bestaettigte Fehler
                $constraints[] = $this->expr()->eq('isDone', true);
                $constraints[] = $this->expr()->eq('isOk', false);
            } else {
                die('unknown status: ' . $status);
            }
            */
        }
        if (isset($search['importFrom']['date']) && $search['importFrom']['date'] !== '') {
            $constraints[] = $this->expr()->gte(
                'date_import',
                $this->createNamedParameter($search['importFrom']['date'])
            );
        }
        if (isset($search['importTo']['date']) && $search['importTo']['date'] !== '') {
            $constraints[] = $this->expr()->lte(
                'date_import',
                $this->createNamedParameter($search['importTo']['date'])
            );
        }
        if (isset($search['valutaFrom']['date']) && $search['valutaFrom']['date'] !== '') {
            $constraints[] = $this->expr()->gte(
                'date_valuta',
                $this->createNamedParameter($search['valutaFrom']['date'])
            );
        }
        if (isset($search['valutaTo']['date']) && $search['valutaTo']['date'] !== '') {
            $constraints[] = $this->expr()->lte(
                'date_valuta',
                $this->createNamedParameter($search['valutaTo']['date'])
            );
        }
        if (isset($search['payFrom']['date']) && $search['payFrom']['date'] !== '') {
            $constraints[] = $this->expr()->gte('date_pay', $this->createNamedParameter($search['payFrom']['date']));
        }
        if (isset($search['payTo']['date']) && $search['payTo']['date'] !== '') {
            $constraints[] = $this->expr()->lte('date_pay', $this->createNamedParameter($search['payTo']['date']));
        }

        $hasBookFrom = (isset($search['bookFrom']['date']) && $search['bookFrom']['date'] !== '');
        $hasBookTo = (isset($search['bookTo']['date']) && $search['bookTo']['date'] !== '');
        if ($hasBookFrom || $hasBookTo) {
            $subselectWhere = [];
            if ($hasBookFrom) {
                $subselectWhere[] = 'DATE(booking_date) >= ' . $this->createNamedParameter($search['bookFrom']['date']);
            }
            if ($hasBookTo) {
                $subselectWhere[] = 'DATE(booking_date) <= ' . $this->createNamedParameter($search['bookTo']['date']);
            }
            $constraints[] = $this->tablename . '.uid IN (SELECT payment FROM ' . $this->invoicepaymentTablename . ' WHERE  ' . implode(
                ' AND ',
                $subselectWhere
            ) . ')';
        }


        if (isset($search['keyword']) && $search['keyword'] !== '') {
            $keywordsArray = GeneralUtility::trimExplode(' ', $search['keyword'], true);
            if (!empty($keywordsArray)) {
                foreach ($keywordsArray as $keyword) {
                    $subConstrains = [];
                    $subConstrains[] = $this->expr()->like('iban', $this->createNamedParameter('%' . $keyword . '%'));
                    $subConstrains[] = $this->expr()->like(
                        'text_info',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $subConstrains[] = $this->expr()->like(
                        'reference',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $subConstrains[] = $this->expr()->like(
                        'debitor_organisation',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $subConstrains[] = $this->expr()->like(
                        'debitor_address',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $subConstrains[] = $this->expr()->eq(
                        $this->tablename . '.uid',
                        $this->createNamedParameter($keyword, Connection::PARAM_INT)
                    );
                    $constraints[] = $this->expr()->or(...$subConstrains);
                }
            }
        }
        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
}
