<?php

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use Ig\IgFibu\Domain\Repository\InvoicePaymentRepository;
use Ig\IgFibu\Service\DebitorService;
use Ig\IgFibu\Utility\InvoiceUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Payment extends AbstractEntity implements FibuAclInterface
{
    /**
     * entryId
     *
     * @var int
     */
    protected $entryId = '';

    /**
     * debitorId
     *
     * @var int
     */
    protected $debitorId;

    /**
     * tablenames
     *
     * @var string
     */
    protected $tablenames = '';

    /**
     * betrag
     *
     * @var float
     */
    protected $betrag = 0.0;

    /**
     * amountApplied
     *
     * @var float
     */
    protected $amountApplied = 0.0;

    /**
     * charges
     *
     * @var float
     */
    protected $charges = 0.0;

    /**
     * iban
     *
     * @var string
     */
    protected $iban = '';

    /**
     * isOk
     *
     * @var bool
     */
    protected $isOk = false;

    /**
     * isDone
     *
     * @var bool
     */
    protected $isDone = false;

    /**
     * textInfo
     *
     * @var string
     */
    protected $textInfo = '';

    /**
     * reference
     *
     * @var string
     */
    protected $reference = '';

    /**
     * referenceBank
     *
     * @var string
     */
    protected $referenceBank = '';

    /**
     * referenceFormat
     *
     * @var string
     */
    protected $referenceFormat = '';

    /**
     * referenceEntry
     *
     * @var string
     */
    protected $referenceEntry = '';

    /**
     * referenceInvoice
     *
     * @var string
     */
    protected $referenceInvoice = '';

    /**
     * debitorOrganisation
     *
     * @var string
     */
    protected $debitorOrganisation = '';

    /**
     * debitorAddress
     *
     * @var string
     */
    protected $debitorAddress = '';

    /**
     * datePay
     *
     * @var DateTime
     */
    protected $datePay = null;

    /**
     * dateValuta
     *
     * @var DateTime
     */
    protected $dateValuta = null;

    /**
     * dateImport
     *
     * @var DateTime
     */
    protected $dateImport = null;

    /**
     * isMissing
     *
     * @var bool
     */
    protected $isMissing = false;

    /**
     * invoice
     *
     * @var Invoice
     */
    protected $invoice = null;

    /**
     * import
     *
     * @var PaymentImport
     */
    protected $import = null;

    /**
     * verbandId
     */
    protected int $verbandId = 0;

    /**
     * verband
     */
    protected ?ClientInterface  $verband = null;

    /**
     * debitor
     *
     * @var object
     */
    protected $debitor = false;


    /**
     * debitorLink
     *
     * @var array
     */
    protected $debitorLink = null;

    /**
     * debitorSettings
     *
     * @var array
     */
    protected $debitorSettings = null;

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;

    /**
     * @var object
     */
    protected $invoicePayments = null;

    public function getStatus()
    {
        if ($this->getIsDone() && $this->getIsOk()) {
            $class = 'ig-fibu-status';
            $style = 'background-color: #00aa00; color: #ffffff;';
            $title = 'Verbucht';
        } elseif ($this->getIsDone() && !$this->getIsOk()) {
            $class = 'ig-fibu-status';
            $style = 'background-color: #aa0000; color: #ffffff;';
            $title = 'Fehler';
        } else {
            $class = 'ig-fibu-status status-can-pay';
            $style = 'background-color: #00aaaa; color: #ffffff;';
            $title = 'Offen';
        }
        return [
            'class' => $class,
            'style' => $style,
            'title' => $title,
        ];
    }


    /**
     * @return DebitorService
     */
    public function getDebitorService()
    {
        if ($this->debitorService === null) {
            $this->debitorService = GeneralUtility::makeInstance(DebitorService::class);
        }
        return $this->debitorService;
    }


    /**
     * Returns the betrag
     *
     * @return float
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    public function getAmount()
    {
        return $this->betrag;
    }

    /**
     * Sets the betrag
     */
    public function setBetrag(float $betrag): void
    {
        $this->betrag = $betrag;
    }
    public function setAmount(float $betrag): void
    {
        $this->betrag = $betrag;
    }

    /**
     * Returns the amountApplied
     *
     * @return float
     */
    public function getAmountApplied()
    {
        return $this->amountApplied;
    }

    /**
     * Sets the amountApplied
     *
     * @param  float $amountApplied
     */
    public function setAmountApplied($amountApplied): void
    {
        $this->amountApplied = $amountApplied;
    }

    /**
     * Add amountApplied
     */
    public function addAmountApplied(float $amountApplied): void
    {
        $this->amountApplied += $amountApplied;
    }
    /**
     * Sub amountApplied
     */
    public function subAmountApplied(float $amountApplied): void
    {
        $this->amountApplied -= $amountApplied;
    }

    public function getAmountOpen()
    {
        return InvoiceUtility::subtractWithEpsilon($this->betrag, $this->amountApplied);
        //return $this->betrag - $this->amountApplied;
    }
    
    /**
     * Returns the iban
     *
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Sets the iban
     *
     * @param  string $iban
     */
    public function setIban($iban): void
    {
        $this->iban = $iban;
    }
    /**
     * Returns the charges
     *
     * @return float
     */
    public function getCharges()
    {
        return $this->charges;
    }

    /**
     * Sets the charges
     *
     * @param  float $charges
     */
    public function setCharges($charges): void
    {
        $this->charges = $charges;
    }

    /**
     * Returns the isOk
     *
     * @return bool
     */
    public function getIsOk()
    {
        return $this->isOk;
    }

    /**
     * Sets the isOk
     *
     * @param  bool $isOk
     */
    public function setIsOk($isOk): void
    {
        $this->isOk = $isOk;
    }

    /**
     * Returns the boolean state of isOk
     *
     * @return bool
     */
    public function isIsOk()
    {
        return $this->isOk;
    }

    /**
     * Returns the isDone
     *
     * @return bool
     */
    public function getIsDone()
    {
        return $this->isDone;
    }

    /**
     * Sets the isDone
     *
     * @param  bool $isDone
     */
    public function setIsDone($isDone): void
    {
        $this->isDone = $isDone;
    }

    /**
     * Returns the boolean state of isDone
     *
     * @return bool
     */
    public function isIsDone()
    {
        return $this->isDone;
    }

    /**
     * Returns the ref
     *
     * @return string reference
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Sets the reference
     *
     * @param  string $reference
     */
    public function setReference($reference): void
    {
        $this->reference = $reference;
    }

    /**
     * Returns the referenceBank
     *
     * @return string
     */
    public function getReferenceBank()
    {
        return $this->referenceBank;
    }

    /**
     * Sets the referenceBank
     *
     * @param  string $referenceBank
     */
    public function setReferenceBank($referenceBank): void
    {
        $this->referenceBank = $referenceBank;
    }


    /**
     * Returns the referenceFormat
     *
     * @return string
     */
    public function getReferenceFormat()
    {
        return $this->referenceFormat;
    }

    /**
     * Sets the referenceFormat
     *
     * @param  string $referenceFormat
     */
    public function setReferenceFormat($referenceFormat): void
    {
        $this->referenceFormat = $referenceFormat;
    }

    /**
     * Returns the referenceEntry
     *
     * @return string
     */
    public function getReferenceEntry()
    {
        return $this->referenceEntry;
    }

    /**
     * Sets the referenceEntry
     *
     * @param  string $referenceEntry
     */
    public function setReferenceEntry($referenceEntry): void
    {
        $this->referenceEntry = $referenceEntry;
    }


    /**
     * Returns the referenceInvoice
     *
     * @return string
     */
    public function getReferenceInvoice()
    {
        return $this->referenceInvoice;
    }

    /**
     * Sets the referenceInvoice
     *
     * @param  string $referenceInvoice
     */
    public function setReferenceInvoice($referenceInvoice): void
    {
        $this->referenceInvoice = $referenceInvoice;
    }

    /**
     * Returns the datePay
     *
     * @return DateTime
     */
    public function getDatePay()
    {
        return $this->datePay;
    }

    /**
     * Sets the datePay
     */
    public function setDatePay(DateTime $datePay = null): void
    {
        $this->datePay = $datePay;
    }

    /**
     * Returns the dateValuta
     *
     * @return DateTime
     */
    public function getDateValuta()
    {
        return $this->dateValuta;
    }

    /**
     * Sets the dateValuta
     */
    public function setDateValuta(DateTime $dateValuta): void
    {
        $this->dateValuta = $dateValuta;
    }

    /**
     * Returns the dateImport
     *
     * @return DateTime
     */
    public function getDateImport()
    {
        return $this->dateImport;
    }

    /**
     * Sets the dateImport
     */
    public function setDateImport(DateTime $dateImport = null): void
    {
        $this->dateImport = $dateImport;
    }

    /**
     * Returns the isMissing
     *
     * @return bool
     */
    public function getIsMissing()
    {
        return $this->isMissing;
    }

    /**
     * Sets the isMissing
     *
     * @param  bool $isMissing
     */
    public function setIsMissing($isMissing): void
    {
        $this->isMissing = $isMissing;
    }

    /**
     * Returns the boolean state of isMissing
     *
     * @return bool
     */
    public function isIsMissing()
    {
        return $this->isMissing;
    }

    /**
     * Returns the invoice
     *
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * Sets the invoice
     */
    public function setInvoice(Invoice $invoice = null): void
    {
        $this->invoice = $invoice;
    }

    /**
     * Returns the import
     *
     * @return PaymentImport
     */
    public function getImport()
    {
        return $this->import;
    }

    /**
     * Sets the import
     */
    public function setImport(PaymentImport $import): void
    {
        $this->import = $import;
    }


    /**
     * Returns the entryId
     *
     * @return int entryId
     */
    public function getEntryId()
    {
        return $this->entryId;
    }

    /**
     * Sets the entryId
     *
     * @param  string $entryId
     */
    public function setEntryId($entryId): void
    {
        $this->entryId = $entryId;
    }

    /**
     * Returns the entryId
     *
     * @return int debitorId
     */
    public function getDebitorId()
    {
        return $this->debitorId;
    }

    /**
     * Sets the debitorId
     */
    public function setDebitorId(int $debitorId = null): void
    {
        $this->debitorId = $debitorId;
    }

    /**
     * Returns the tablenames
     *
     * @return string
     */
    public function getTablenames()
    {
        return $this->tablenames;
    }
    /**
     * Sets the tablenames
     *
     * @param  string $tablenames
     */
    public function setTablenames($tablenames): void
    {
        $this->tablenames = $tablenames;
    }
    public function setTablenamesByFormat($referenceFormat): void
    {
        $this->getDebitorSettings();
        $this->tablenames = $this->getDebitorService()
->getTablenamesByFormat($referenceFormat);
    }
    /**
     * Get Debitor Object
     */
    public function getDebitor()
    {
        $this->fixTablenames();

        if ($this->debitor === false) {
            $modelClassName = $this->getDebitorService()
->getModelClassName($this->tablenames);
            if ($modelClassName) {
                $repositoryClassName = $this->getDebitorService()
->getRepositoryClassName($this->tablenames);
                if ($repositoryClassName) {
                    $repository = GeneralUtility::makeInstance($repositoryClassName);
                    if ($this->debitorId) {
                        $this->debitor = $repository->findByUid($this->debitorId);
                    } else {
                        // @todo löschen
                        $debitorMethod = $this->getDebitorService()
->getDebitorMethod($this->tablenames);
                        if ($debitorMethod == 'igs') {
                            if ($this->tablenames == 'Organisation') {
                                $this->debitor = $repository->findOneByMeAddressid($this->entryId - 800000);
                            } else {
                                $this->debitor = $repository->findOneByMeAddressid($this->entryId);
                            }
                        } else {
                            $this->debitor = $repository->findByUid($this->entryId);
                        }
                    }
                } else {
                    $this->debitor = null;
                }
            } else {
                $this->debitor = null;
            }
        }
        return $this->debitor;
    }
    /**
     * Get Link Uid
     */
    /*
    public function getDebitorLink()
    {
        if ($this->debitorLink === null) {
            $this->getDebitor();
            $type = $this->debitor ? $this->debitor->getType() : '';
            $debitorUid = $this->debitor ? $this->debitor->getUid() : $this->entryId;
            $this->debitorLink = $this->getDebitorService()->getLink($type ? : $this->tablenames, $debitorUid, $this->verbandId, $type);
        }
        return $this->debitorLink;
    }
*/

    /**
     * Sets the Debitor(tablenames + entryId)
     *
     * @param  string $tablenames
     * @param  string $entryId
     */
    public function setDebitor($tablenames, $entryId): void
    {
        $this->tablenames = $tablenames;
        $this->entryId = $entryId;
    }

    /**
     * Returns the textInfo
     *
     * @return string textInfo
     */
    public function getTextInfo()
    {
        return $this->textInfo;
    }

    /**
     * Sets the textInfo
     *
     * @param  string $textInfo
     */
    public function setTextInfo($textInfo): void
    {
        $this->textInfo = $textInfo;
    }

    /**
     * Returns the debitorOrganisation
     *
     * @return string debitorOrganisation
     */
    public function getDebitorOrganisation()
    {
        return $this->debitorOrganisation;
    }

    /**
     * Sets the debitorOrganisation
     *
     * @param  string $debitorOrganisation
     */
    public function setDebitorOrganisation($debitorOrganisation): void
    {
        $this->debitorOrganisation = $debitorOrganisation;
    }

    /**
     * Returns the debitorOrganisation
     *
     * @return string debitorAddress
     */
    public function getDebitorAddress()
    {
        return $this->debitorAddress;
    }

    /**
     * Sets the debitorAddress
     *
     * @param  string $debitorAddress
     */
    public function setDebitorAddress($debitorAddress): void
    {
        $this->debitorAddress = $debitorAddress;
    }

    /**
     * Returns the verbandId
     *
     * @return int
     */
    public function getVerbandId()
    {
        return $this->verbandId;
    }
    public function getTenantId(): int
    {
        return $this->verbandId;
    }
    public function getVerband()
    {
        if ($this->verband === null) {
            $conf = $this->getDebitorService()
->getMandantConfig();
            if ($conf['repository']) {
                if ($this->verbandId) {
                    $verbandRepository = GeneralUtility::makeInstance($conf['repository']);
                    $this->verband = $verbandRepository->findOneByUid($this->verbandId);
                } else {
                    die('repository: ' . $conf['repository'] . ' is set, but creditorId in invoice is not set');
                }
            } else {
                $creditor = GeneralUtility::makeInstance(Creditor::class);
                $creditor->setArray($conf['default']);
                $creditor->setUid(0); //bugfix for use of verband in links
                $this->verband = $creditor;
            }
            //var_dump($conf['repository'],$this->verband);die('a');
        }
        return $this->verband;
    }

    /**
     * Sets the verbandId
     */
    public function setVerbandId(int $verbandId): void
    {
        $this->verbandId = $verbandId;
    }

    public function fixTablenames(): void
    {
        // Fix IGS ohne referenceFormat
        if (!$this->tablenames) {
            if ($this->entryId >= 800000) {
                $this->tablenames = 'Organisation';
                //$this->entryId -= 800000;
            } else {
                $this->tablenames = 'Person';
            }
        }
    }

    public function getInvoicePayments()
    {
        if ($this->invoicePayments === null) {
            $invoicePaymentRepository = GeneralUtility::makeInstance(InvoicePaymentRepository::class);
            $this->invoicePayments = $invoicePaymentRepository->findBy([
                'payment' => $this->uid,
            ]);
            //var_dump($this->uid, $this->invoicePayments->count());exit(0);
        }
        return $this->invoicePayments;
    }

    

    public function getDebitorSettings()
    {
        $this->fixTablenames();
        if ($this->debitorSettings === null) {
            $this->debitorSettings = $this->getDebitorService()
->getConfig($this->tablenames);
            if ($this->debitorSettings === false) {
                $this->debitorSettings = [];
            }
        }
        return $this->debitorSettings;
    }
}
