<?php

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class PaymentImport extends AbstractEntity implements FibuAclInterface
{
    // folder to save the uploaded file or null to deactivate the featrue
    public static $pathForFileUploads = 'fileadmin_secure/ig_fibu';


    /**
     * filename
     */
    protected string $filename = '';

    /**
     * msg_id
     */
    protected string $msgId = '';

    /**
     * ntfctn_id
     */
    protected string $ntfctnId = '';

    /**
     * account_iban
     */
    protected $accountIban = '';

    /**
     * createDate
     *
     * @var DateTime
     */
    protected $createDate = null;

    /**
     * verbandId
     */
    protected int $verbandId = 0;

    /**
     * filesCount
     *
     * @var int
     */
    protected $filesCount = 0;

    /**
     * entriesCount
     *
     * @var int
     */
    protected $entriesCount = 0;

    /**
     * entriesBetrag
     *
     * @var float
     */
    protected $entriesBetrag = 0.0;



    public function __construct()
    {
        $this->createDate = new DateTime();
    }
    /**
     * Returns the filename
     */
    public function getFilename(): string
    {
        return $this->filename;
    }
    public function getFilenameLink()
    {
        return '/' . self::$pathForFileUploads . '/' . $this->uid . '/' . $this->filename;
    }
    public function getFilenameAbsolutePath()
    {
        return Environment::getPublicPath() . '/' . self::$pathForFileUploads . '/' . $this->uid . '/' . $this->filename;
    }
    public function getFilenameExists()
    {
        return file_exists($this->getFilenameAbsolutePath());
    }

    /**
     * Sets the filename
     */
    public function setFilename(string $filename): void
    {
        $this->filename = $filename;
    }


    /**
     * Returns the msgId
     */
    public function getMsgId(): string
    {
        return $this->msgId;
    }

    /**
     * Sets the msgId
     */
    public function setMsgId(string $msgId): void
    {
        $this->msgId = $msgId;
    }

    /**
     * Returns the ntfctnId
     */
    public function getNtfctnId(): string
    {
        return $this->ntfctnId;
    }

    /**
     * Sets the ntfctnId
     */
    public function setNtfctnId(string $ntfctnId): void
    {
        $this->ntfctnId = $ntfctnId;
    }

    /**
     * Returns the accountIban
     */
    public function getAccountIban(): string
    {
        return $this->accountIban;
    }

    /**
     * Sets the accountIban
     */
    public function setAccountIban(string $accountIban): void
    {
        $this->accountIban = $accountIban;
    }

    
    /**
     * Returns the createDate
     *
     * @return DateTime
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }

    /**
     * Sets the createDate
     */
    public function setCreateDate(DateTime $createDate): void
    {
        $this->createDate = $createDate;
    }

    /**
     * Returns the verbandId
     */
    public function getVerbandId(): int
    {
        return $this->verbandId;
    }
    public function getTenantId(): ?int
    {
        return $this->verbandId;
    }

    /**
     * Sets the verbandId
     */
    public function setVerbandId(int $verbandId): void
    {
        $this->verbandId = $verbandId;
    }



    /**
     * Returns the filesCount
     *
     * @return int
     */
    public function getFilesCount()
    {
        return $this->filesCount;
    }

    /**
     * Sets the filesCount
     *
     * @param  int $filesCount
     */
    public function setFilesCount($filesCount): void
    {
        $this->filesCount = $filesCount;
    }

    /**
     * Returns the entriesCount
     *
     * @return int
     */
    public function getEntriesCount()
    {
        return $this->entriesCount;
    }

    /**
     * Sets the entriesCount
     *
     * @param  int $entriesCount
     */
    public function setEntriesCount($entriesCount): void
    {
        $this->entriesCount = $entriesCount;
    }


    /**
     * Returns the entriesBetrag
     *
     * @return float
     */
    public function getEntriesBetrag()
    {
        return $this->entriesBetrag;
    }

    /**
     * Sets the entriesBetrag
     *
     * @param  float $entriesBetrag
     */
    public function setEntriesBetrag($entriesBetrag): void
    {
        $this->entriesBetrag = $entriesBetrag;
    }
}
