<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for InvoicePayments
 */
class InvoicePaymentRepository extends Repository
{
    protected $defaultOrderings = [
        'booking_date' => QueryInterface::ORDER_ASCENDING,
        'uid' => QueryInterface::ORDER_ASCENDING,
    ];

    public function findPaymentByInvoice(int $invoiceUid)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd($query->equals('invoice', $invoiceUid), $query->greaterThan('payment', 0))
        );
        return $query->execute();
    }
    public function findCreditByInvoice(int $invoiceUid, $postPayment = null)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('invoice', $invoiceUid), $query->greaterThan('credit', 0)];
        if ($postPayment !== null) {
            $constraints[] = $query->equals('postPayment', $postPayment);
        }
        $query->matching($query->logicalAnd(...$constraints));
         
        return $query->execute();
    }
}
