<?php

namespace Ig\IgFibu\Domain\Repository;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Invoicestatuses
 */
class InvoicestatusRepository extends Repository
{
    protected static $tablename = 'tx_igfibu_domain_model_invoicestatus';
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
    ];


    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * return all uids which are reminders
     */
    public static function getUidsReminder(): array
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(static::$tablename);
        $res = $queryBuilder
            ->select('uid')
             ->from(static::$tablename)
             ->where(
                $queryBuilder->expr()->eq('deleted', 0),
                $queryBuilder->expr()->eq('sys_language_uid', 0),
                $queryBuilder->expr()->eq('is_reminder', 1),
            )
             ->executeQuery();
        return $res->fetchFirstColumn();
    }

    /**
     * return all uids which are suspended
     */
    public static function getUidsSuspended(): array
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(static::$tablename);
        $res = $queryBuilder
            ->select('uid')
             ->from(static::$tablename)
             ->where(
                $queryBuilder->expr()->eq('deleted', 0),
                $queryBuilder->expr()->eq('sys_language_uid', 0),
                $queryBuilder->expr()->eq('is_suspended', 1),
            )
             ->executeQuery();
        return $res->fetchFirstColumn();
    }

    /**
     * return all uids with is_draft
     */
    public static function getUidsDraft(): array
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(static::$tablename);
        $res = $queryBuilder
            ->select('uid')
             ->from(static::$tablename)
             ->where(
                $queryBuilder->expr()->eq('deleted', 0),
                $queryBuilder->expr()->eq('sys_language_uid', 0),
                $queryBuilder->expr()->eq('is_draft', 1),
            )
             ->executeQuery();
        return $res->fetchFirstColumn();
    }
}
