<?php

namespace Ig\IgFibu\ReferenceFormatter;

use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;

abstract class AbstractReferenceFormatter
{
    /**
     * Priority: hight comes first
     */
    protected int $priority = 0;
    protected string $referenceFormat = '';

    /**
     * get priority for convertion
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * can this ReferenceFormatter convert the givent reference
     */
    abstract public function canConvert(string $reference, ?int $tenantId): bool;

    /**
     * Actually convert reference
     */
    abstract public function convert(string $reference, ?int $tenantId): ReferenceFormatterResult;

    /**
     * get reference for swiss QR code with debitor and invoice id
     * max length is 26, smaller will be left padded with 0, check digit is appended
     */
    abstract public function getReference(AddressInterface $debitor, int $invoiceId): string;


    /**
     * get RF reference for QR Code with IBAN for foreign countries
     * max length is 20, smaller will be left padded with 0, check digits are added
     */
    abstract public function getRFReference(AddressInterface $debitor, int $invoiceId): string;
}
