<?php

use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Model\InvoiceItemUnit;

return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem',
        'label' => 'title',
        'label_alt' => 'description',
        'tstamp' => 'tstamp',
        'type' => 'type',
        'crdate' => 'crdate',
        'sortby' => 'sorting',
        'delete' => 'deleted',
        'searchFields' => 'title,description, amount, quantity,unit_price,tax_rate,tax_behavior',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_invoiceitem.gif'
    ],
    'types' => [
        '0' => ['showitem' => 'type, title, description, quantity, unit_price, amount, tax_behavior, tax_rate, cost_center, period'],
        InvoiceItem::class => ['showitem' => 'type, title, description, quantity, unit_price, amount, tax_behavior, tax_rate, cost_center, period'],
        InvoiceItemUnit::class => ['showitem' => 'type, title, description, quantity, unit_price, amount, tax_behavior, tax_rate, cost_center, period'],
    ],
    'columns' => [
        'type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.type.invoiceitem', 'value' => InvoiceItem::class ],
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.type.invoiceitem_unit', 'value' => InvoiceItemUnit::class ],
                ],
                'default' => InvoiceItem::class,
                'nullable' => true,
            ],
        ],


        'sorting' => [
            'config' => [
                'type' => 'passthrough',
            ]
        ],

        
        'is_local_text' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.is_local_text',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ]
        ],
        'total_exkl' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.total_exkl',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'total_inkl' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.total_inkl',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'quantity' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.quantity',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'unit_price' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.unit_price',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'tax_rate' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.tax_rate',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
                'format' => 'decimal'
            ]
        ],
        'tax_behavior' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.tax_behavior',
            'config' => [
                'type' => 'input',
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [ 'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.tax_behavior.exclusive', 'value' => 0],
                    [ 'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.tax_behavior.inclusive', 'value' => 1],
                ],
                'default' => 0,
            ]
        ],
        'cost_center' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.cost_center',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igfibu_domain_model_costcenter',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'period' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igs_crm/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.period',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
    
        'invoice' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
    ],
];
