<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoicescheme',
        'label' => 'verband_id',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
        ],
        'searchFields' => 'verband_id,nummer,title',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_invoicescheme.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, hidden, verband_id, nummer, title, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igfibu_domain_model_invoicescheme',
                'foreign_table_where' => 'AND tx_igfibu_domain_model_invoicescheme.pid=###CURRENT_PID### AND tx_igfibu_domain_model_invoicescheme.sys_language_uid IN (-1,0)',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],

        'verband_id' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoicescheme.verband_id',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'nummer' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoicescheme.nummer',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoicescheme.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
    
    ],
];
