#
# Table structure for table 'tx_igfibu_domain_model_invoice'
#
CREATE TABLE tx_igfibu_domain_model_invoice (
        type varchar(255) DEFAULT '' NOT NULL,
	verband_id int(11) DEFAULT '0' NOT NULL,
	entry_id int(11) DEFAULT '0' NOT NULL,
	tablenames varchar(64) DEFAULT '' NOT NULL,
	position varchar(255) DEFAULT '' NOT NULL,
	periode varchar(255) DEFAULT '' NOT NULL,
	mode int(11) DEFAULT '0' NOT NULL,
	create_date date DEFAULT NULL,
	modified_date date DEFAULT NULL,
	invoice_date date DEFAULT NULL,
	paid_date date DEFAULT NULL,
	subtotal decimal(11,2) DEFAULT '0.00' NOT NULL,
	subtotal_exkl decimal(11,2) DEFAULT '0.00' NOT NULL,
	discount_percentage decimal(11,2) DEFAULT '0.00' NOT NULL,
	discount_amount decimal(11,2) DEFAULT '0.00' NOT NULL,
	total_discount decimal(11,2) DEFAULT '0.00' NOT NULL,
	tax_rate decimal(11,2) DEFAULT '0.00' NOT NULL,
	total_tax decimal(11,2) DEFAULT '0.00' NOT NULL,
	total_exkl decimal(11,2) DEFAULT '0.00' NOT NULL,
	total decimal(11,2) DEFAULT '0.00' NOT NULL,
	pre_payment_credit_amount decimal(11,2) DEFAULT '0.00' NOT NULL,
	post_payment_credit_amount decimal(11,2) DEFAULT '0.00' NOT NULL,
	amount_paid decimal(11,2) DEFAULT '0.00' NOT NULL,
	letter_date date DEFAULT NULL,
	invoiceitem int(11) unsigned DEFAULT '0' NOT NULL,
	status int(11) unsigned DEFAULT '0',
	art int(11) unsigned DEFAULT '0',
	customer_reference varchar(255) DEFAULT '' NOT NULL,
	description text,
	invoice_address text,
	delivery_address text,
	INDEX tx_igfibu_index_invoice_debitor (entry_id,verband_id),
);

#
# Table structure for table 'tx_igfibu_domain_model_payment'
#
CREATE TABLE tx_igfibu_domain_model_payment (
	verband_id int(11) DEFAULT '0' NOT NULL,
	betrag decimal(11,2) DEFAULT '0.00' NOT NULL,
	amount_applied decimal(11,2) DEFAULT '0.00' NOT NULL,
	charges decimal(11,2) DEFAULT '0.00' NOT NULL,
	is_ok smallint(5) unsigned DEFAULT '0' NOT NULL,
	is_done smallint(5) unsigned DEFAULT '0' NOT NULL,
	iban varchar(255) DEFAULT '' NOT NULL,
	text_info varchar(255) DEFAULT '' NOT NULL,
	debitor_organisation varchar(255) DEFAULT '' NOT NULL,
	debitor_address text,
	date_pay date DEFAULT NULL,
	date_valuta date DEFAULT NULL,
	date_import date DEFAULT NULL,
	reference varchar(255) DEFAULT '' NOT NULL,
	reference_bank varchar(255) DEFAULT '' NOT NULL,
	reference_format varchar(255) DEFAULT '' NOT NULL,
	reference_entry varchar(255) DEFAULT '' NOT NULL,
	reference_invoice varchar(255) DEFAULT '' NOT NULL,
	entry_id int(11) DEFAULT '0' NOT NULL,
	debitor_id int(11),
	tablenames varchar(64) DEFAULT '' NOT NULL,
	is_missing smallint(5) unsigned DEFAULT '0' NOT NULL,
	invoice int(11) unsigned DEFAULT '0',
	import int(11) unsigned DEFAULT '0',
	INDEX tx_igfibu_index_payment_debitor (debitor_id,verband_id),
);

#
# Table structure for table 'tx_igfibu_domain_model_invoicescheme'
#
CREATE TABLE tx_igfibu_domain_model_invoicescheme (
	verband_id int(11) DEFAULT '0' NOT NULL,
	nummer int(11) DEFAULT '0' NOT NULL,
	title varchar(255) DEFAULT '' NOT NULL,
);

#
# Table structure for table 'tx_igfibu_domain_model_invoiceitem' (invoice item)
#
CREATE TABLE tx_igfibu_domain_model_invoiceitem (
	type varchar(255) DEFAULT '' NOT NULL,
	invoice int(11) unsigned DEFAULT '0' NOT NULL,
	cost_center int(11) unsigned,
	is_local_text tinyint(4) unsigned DEFAULT '0' NOT NULL,
	title varchar(255) DEFAULT '' NOT NULL,
	description text,
	amount decimal(11,2) DEFAULT '0.00' NOT NULL,
	total_exkl decimal(11,2) DEFAULT '0.00' NOT NULL,
	total_inkl decimal(11,2) DEFAULT '0.00' NOT NULL,
	quantity decimal(11,2) DEFAULT '0.00' NOT NULL,
	unit_price decimal(11,2) DEFAULT '0.00' NOT NULL,
	tax_rate decimal(11,2),
	tax_behavior smallint(5) unsigned,
 	period varchar(255),
	INDEX tx_igfibu_index_invoice (invoice),
);

#
# Table structure for table 'tx_igfibu_domain_model_costcenter'
#
CREATE TABLE tx_igfibu_domain_model_costcenter (
	verband_id int(11),
	code varchar(255) NOT NULL,
	title varchar(255) DEFAULT '' NOT NULL,
	invoice_attribute varchar(255),
	invoiceitem_types varchar(255),
);


CREATE TABLE tx_igfibu_domain_model_credit (
	tenant_id int(11) NOT NULL DEFAULT '0',
	debitor_id int(11) NOT NULL DEFAULT '0',
	title varchar(255) NOT NULL DEFAULT '',
	amount decimal(11,2) NOT NULL DEFAULT '0.00',
	create_date datetime DEFAULT NULL,
	due_date date DEFAULT NULL,
	is_done smallint(5) unsigned DEFAULT '0' NOT NULL,
);
CREATE TABLE tx_igfibu_domain_model_mastercredit (
	tenant_id int(11) NOT NULL DEFAULT '0',
	name varchar(255) NOT NULL DEFAULT '',
	title varchar(255) NOT NULL DEFAULT '',
	amount decimal(11,2),
	due_date date DEFAULT NULL,
);
CREATE TABLE tx_igfibu_domain_model_invoicepayment (
	tenant_id int(11) NOT NULL DEFAULT '0',
	debitor_id int(11) NOT NULL DEFAULT '0',
	amount_applied decimal(11,2) NOT NULL DEFAULT '0.00',
	booking_date datetime DEFAULT NULL,
	invoice int(11) unsigned DEFAULT '0',
	payment int(11) unsigned DEFAULT '0',
	credit int(11) unsigned DEFAULT '0',
	post_payment tinyint(4) unsigned DEFAULT '0' NOT NULL,
);

#
# Table structure for table 'tx_igfibu_domain_model_invoicestatus'
#
CREATE TABLE tx_igfibu_domain_model_invoicestatus (
	title varchar(255) DEFAULT '' NOT NULL,
	document_title varchar(255) DEFAULT '' NOT NULL,
	document_title_short varchar(255) DEFAULT '' NOT NULL,
	filename_part varchar(255) DEFAULT '' NOT NULL,
	color varchar(255) DEFAULT '' NOT NULL,
	background_color varchar(255) DEFAULT '' NOT NULL,
	deadline_in_days int(11) DEFAULT '0' NOT NULL,
	deadline_step int(11) unsigned,
	can_send smallint(5) unsigned DEFAULT '0' NOT NULL,
	is_sent smallint(5) unsigned DEFAULT '0' NOT NULL,
	delivery_step int(11) unsigned,	
	next_step int(11) unsigned DEFAULT '0' NOT NULL,
	can_delete tinyint(4) unsigned DEFAULT '0' NOT NULL,
	can_edit tinyint(4) unsigned DEFAULT '0' NOT NULL,
	can_pay tinyint(4) unsigned DEFAULT '1' NOT NULL,
	use_payments tinyint(4) unsigned DEFAULT '0' NOT NULL,
	is_draft tinyint(3) unsigned DEFAULT '1'  NOT NULL,
	is_suspended tinyint(3) unsigned DEFAULT '0'  NOT NULL,
	is_paid tinyint(3) unsigned DEFAULT '0'  NOT NULL,
	is_finished tinyint(3) unsigned DEFAULT '0'  NOT NULL,
	is_in_statistic tinyint(3) unsigned DEFAULT '1'  NOT NULL,
	is_reminder tinyint(3) unsigned DEFAULT '0'  NOT NULL,
);

#
# Table structure for table 'tx_igfibu_domain_model_paymentimport'
#
CREATE TABLE tx_igfibu_domain_model_paymentimport (
	verband_id int(11) DEFAULT '0' NOT NULL,
	filename varchar(255) DEFAULT '' NOT NULL,
	create_date datetime DEFAULT NULL,
	msg_id varchar(255) DEFAULT '' NOT NULL,
	ntfctn_id varchar(255) DEFAULT '' NOT NULL,
	account_iban varchar(255) DEFAULT '' NOT NULL,
	files_count int(11) DEFAULT '0' NOT NULL,
	entries_count int(11) DEFAULT '0' NOT NULL,
	entries_betrag decimal(11,2) DEFAULT '0.00' NOT NULL,
);

#
# Table structure for table 'tx_igfibu_invoicestatus_invoicestatus_mm'
#
CREATE TABLE tx_igfibu_invoicestatus_invoicestatus_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

CREATE TABLE tx_igfibu_domain_model_mailqueue (
       uid int unsigned NOT NULL AUTO_INCREMENT,
       invoice int(11) unsigned NOT NULL,
       verband_id int(11) unsigned,
       PRIMARY KEY (uid),
);

CREATE TABLE tx_igfibu_domain_model_invoicedate (
        create_date datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
	invoice_date date DEFAULT NULL,
	invoice int(11) unsigned DEFAULT '0',
	status int(11) unsigned DEFAULT '0',
	action int(11) DEFAULT '0' NOT NULL,
	delivery_method int(11),
	log_mail int(11),
        frontend_user int(11) unsigned,
);


CREATE TABLE tx_igfibu_domain_model_log_mail (
        uid int unsigned NOT NULL AUTO_INCREMENT,
  	verband_id int(11) DEFAULT NULL,
  	entry_id int(11) DEFAULT NULL,
	entry_ids text,
	create_date datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  	lm_mail_to text,
  	lm_re_betrag_ez text,
  	lm_invoice_re_id text,
  	lm_invoice_count int(11) DEFAULT NULL,
  	lm_periode_name text,
  	lm_subject text,
  	lm_language int(11) unsigned,
  	PRIMARY KEY (uid)
);
