<?php

namespace Ig\IgFibu\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Invoicestatus extends AbstractEntity
{
    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * filenamePart
     *
     * @var string
     */
    protected $filenamePart = '';

    /**
     * documentTitle
     *
     * @var string
     */
    protected $documentTitle = '';

    /**
     * documentTitleShort
     *
     * @var string
     */
    protected $documentTitleShort = '';

    /**
     * color
     *
     * @var string
     */
    protected $color = '';

    /**
     * backgroundColor
     *
     * @var string
     */
    protected $backgroundColor = '';

    /**
     * deadlineInDays
     *
     * @var int
     */
    protected $deadlineInDays = 0;

    /**
     * deadlineStep
     *
     * @var int
     */
    protected $deadlineStep = null;

    /**
     * sorting
     *
     * @var int
     */
    protected $sorting = 0;

    /**
     * Invoice can be send
     *
     * @var bool
     */
    protected $canSend = false;

    /**
     * invoice is sent
     *
     * @var bool
     */
    protected $isSent = false;

    /**
     * deliveryStep
     *
     * @var int
     */
    protected $deliveryStep = null;


    /**
     * nextStep
     *
     * @var ObjectStorage<\Ig\IgFibu\Domain\Model\Invoicestatus>
     */
    protected $nextStep = null;


    /**
     * usePayments
     *
     * @var bool
     */
    protected $usePayments = false;

    /**
     * isDraft
     *
     * @var bool
     */
    protected $isDraft = false;

    /**
     * isSuspended
     *
     * @var bool
     */
    protected $isSuspended = false;

    /**
     * isPaid
     *
     * @var bool
     */
    protected $isPaid = false;

    /**
     * isFinished
     *
     * @var bool
     */
    protected $isFinished = false;

    /**
     * isReminder
     *
     * @var bool
     */
    protected $isReminder = false;
    
    /**
     * isInStatistic
     *
     * @var bool
     */
    protected $isInStatistic = true;
    

    /**
     * canEdit
     *
     * @var bool
     */
    protected $canEdit = false;


    /**
     * canDelete
     *
     * @var bool
     */
    protected $canDelete = false;

    /**
     * canPay
     *
     * @var bool
     */
    protected $canPay = true;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    public function __toString(): string
    {
        return $this->title;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param  string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the documentTitle
     *
     * @return string
     */
    public function getDocumentTitle()
    {
        return $this->documentTitle;
    }

    /**
     * Sets the documentTitle
     *
     * @param  string $documentTitle
     */
    public function setDocumentTitle($documentTitle): void
    {
        $this->documentTitle = $documentTitle;
    }

    /**
     * Returns the documentTitleShort
     *
     * @return string
     */
    public function getDocumentTitleShort()
    {
        return $this->documentTitleShort;
    }

    /**
     * Sets the documentTitleShort
     *
     * @param  string $documentTitleShort
     */
    public function setDocumentTitleShort($documentTitleShort): void
    {
        $this->documentTitleShort = $documentTitleShort;
    }
    
    /**
     * Returns the filenamePart
     *
     * @return string
     */
    public function getFilenamePart()
    {
        return $this->filenamePart;
    }

    /**
     * Sets the filenamePart
     *
     * @param  string $filenamePart
     */
    public function setFilenamePart($filenamePart): void
    {
        $this->filenamePart = $filenamePart;
    }

    /**
     * Returns the color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Sets the color
     *
     * @param  string $color
     */
    public function setColor($color): void
    {
        $this->color = $color;
    }

    /**
     * Returns the backgroundColor
     *
     * @return string
     */
    public function getBackgroundColor()
    {
        return $this->backgroundColor;
    }

    /**
     * Sets the backgroundColor
     *
     * @param  string $backgroundColor
     */
    public function setBackgroundColor($backgroundColor): void
    {
        $this->backgroundColor = $backgroundColor;
    }

    /**
     * Returns the deadlineInDays
     *
     * @return int
     */
    public function getDeadlineInDays()
    {
        return $this->deadlineInDays;
    }

    /**
     * Sets the deadlineInDays
     *
     * @param  int $deadlineInDays
     */
    public function setDeadlineInDays($deadlineInDays): void
    {
        $this->deadlineInDays = $deadlineInDays;
    }


    /**
     * Returns the deadlineStep
     *
     * @return int
     */
    public function getDeadlineStep()
    {
        return $this->deadlineStep;
    }

    /**
     * Sets the deadlineStep
     *
     * @param  int $deadlineStep
     */
    public function setDeadlineStep($deadlineStep): void
    {
        $this->deadlineStep = $deadlineStep;
    }

    
    /**
     * Returns the sorting
     *
     * @return int
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param  int $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Returns the canSend
     *
     * @return bool
     */
    public function getCanSend()
    {
        return $this->canSend;
    }

    /**
     * Sets the canSend
     *
     * @param  bool $canSend
     */
    public function setCanSend($canSend): void
    {
        $this->canSend = $canSend;
    }

    /**
     * Returns the boolean state of canSend
     *
     * @return bool
     */
    public function isCanSend()
    {
        return $this->canSend;
    }

    /**
     * Returns the isSent
     *
     * @return bool
     */
    public function getIsSent()
    {
        return $this->isSent;
    }

    /**
     * Sets the isSent
     *
     * @param  bool $isSent
     */
    public function setIsSent($isSent): void
    {
        $this->isSent = $isSent;
    }


    /**
     * Returns the deliveryStep
     *
     * @return int
     */
    public function getDeliveryStep()
    {
        return $this->deliveryStep;
    }

    /**
     * Sets the deliveryStep
     *
     * @param  int $deliveryStep
     */
    public function setDeliveryStep($deliveryStep): void
    {
        $this->deliveryStep = $deliveryStep;
    }

    /**
     * Adds a Invoicestatus
     */
    public function addNextStep(self $nextStep): void
    {
        $this->nextStep->attach($nextStep);
    }

    /**
     * Removes a Invoicestatus
     *
     * @param  \Ig\IgFibu\Domain\Model\Invoicestatus $nextStepToRemove The Invoicestatus to be removed
     */
    public function removeNextStep(self $nextStepToRemove): void
    {
        $this->nextStep->detach($nextStepToRemove);
    }

    /**
     * Returns the nextStep
     *
     * @return ObjectStorage<\Ig\IgFibu\Domain\Model\Invoicestatus> $nextStep
     */
    public function getNextStep()
    {
        return $this->nextStep;
    }

    /**
     * Sets the nextStep
     *
     * @param ObjectStorage<\Ig\IgFibu\Domain\Model\Invoicestatus> $nextStep
     */
    public function setNextStep(ObjectStorage $nextStep): void
    {
        $this->nextStep = $nextStep;
    }

    /**
     * Returns the usePayments
     *
     * @return bool
     */
    public function getUsePayments()
    {
        return $this->usePayments;
    }

    /**
     * Sets the usePayments
     *
     * @param  bool $usePayments
     */
    public function setUsePayments($usePayments): void
    {
        $this->usePayments = $usePayments;
    }


    /**
     * Returns the isDraft
     *
     * @return bool
     */
    public function getIsDraft()
    {
        return $this->isDraft;
    }

    /**
     * Sets the isDraft
     *
     * @param  bool $isDraft
     */
    public function setIsDraft($isDraft): void
    {
        $this->isDraft = $isDraft;
    }

    /**
     * Returns the isSuspended
     *
     * @return bool
     */
    public function getIsSuspended()
    {
        return $this->isSuspended;
    }

    /**
     * Sets the isSuspended
     *
     * @param  bool $isSuspended
     */
    public function setIsSuspended($isSuspended): void
    {
        $this->isSuspended = $isSuspended;
    }

    /**
     * Returns the isPaid
     *
     * @return bool
     */
    public function getIsPaid()
    {
        return $this->isPaid;
    }

    /**
     * Sets the isPaid
     *
     * @param  bool $isPaid
     */
    public function setIsPaid($isPaid): void
    {
        $this->isPaid = $isPaid;
    }

    /**
     * Returns the isFinished
     *
     * @return bool
     */
    public function getIsFinished()
    {
        return $this->isFinished;
    }

    /**
     * Sets the isFinished
     *
     * @param  bool $isFinished
     */
    public function setIsFinished($isFinished): void
    {
        $this->isFinished = $isFinished;
    }

    /**
     * Returns the isReminder
     *
     * @return bool
     */
    public function getIsReminder()
    {
        return $this->isReminder;
    }

    /**
     * Sets the isReminder
     *
     * @param  bool $isReminder
     */
    public function setIsReminder($isReminder): void
    {
        $this->isReminder = $isReminder;
    }

    /**
     * Returns the isInStatistic
     *
     * @return bool
     */
    public function getIsInStatistic()
    {
        return $this->isInStatistic;
    }

    /**
     * Sets the isInStatistic
     *
     * @param  bool $isInStatistic
     */
    public function setIsInStatistic($isInStatistic): void
    {
        $this->isInStatistic = $isInStatistic;
    }
    
    /**
     * Returns the canEdit
     *
     * @return bool
     */
    public function getCanEdit()
    {
        return $this->canEdit;
    }

    /**
     * Sets the canEdit
     *
     * @param  bool $canEdit
     */
    public function setCanEdit($canEdit): void
    {
        $this->canEdit = $canEdit;
    }


    /**
     * Returns the canDelete
     *
     * @return bool
     */
    public function getCanDelete()
    {
        return $this->canDelete;
    }

    /**
     * Sets the canDelete
     *
     * @param  bool $canDelete
     */
    public function setCanDelete($canDelete): void
    {
        $this->canDelete = $canDelete;
    }

    /**
     * Returns the canPay
     *
     * @return bool
     */
    public function getCanPay()
    {
        return $this->canPay;
    }

    /**
     * Sets the canPay
     *
     * @param  bool $canPay
     */
    public function setCanPay($canPay): void
    {
        $this->canPay = $canPay;
    }



    
    public function getClass()
    {
        return 'ig-fibu-status' . ($this->canEdit ? ' status-can-edit' : '') . ($this->canDelete ? ' status-can-delete' : '') . ($this->canPay ? ' status-can-pay' : '');
    }
    public function getStyle()
    {
        return 'background-color: ' . $this->getBackgroundColor() . '; color: ' . $this->getColor() . '; ';
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->nextStep = new ObjectStorage();
    }
}
