<?php

namespace Ig\IgFibu\Domain\Repository;

use Ig\IgFibu\Domain\Model\CostCenter;

use Ig\IgFibu\Domain\Model\InvoiceItem;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for CostCenter
 */
class CostCenterRepository extends Repository
{
    protected static $tablename = 'tx_igfibu_domain_model_costcenter';

    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
        'code' => QueryInterface::ORDER_ASCENDING,
        'title' => QueryInterface::ORDER_DESCENDING,
    ];

    public function findForVerband(int $verbandId = null, bool $returnRawQueryResult = false)
    {
        $query = $this->createQuery();
        $constraints = [];

        

        $query->matching(
            $query->logicalOr($query->equals('verbandId', $verbandId), $query->equals('verbandId', null))
        );
        
        return $query->execute($returnRawQueryResult);
    }

    public function createQueryBuilderByVerbandAndType(int $verbandId = null, string $type = null)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            static::$tablename
        );
        $queryBuilder->select(static::$tablename . '.*');
        $queryBuilder->from(static::$tablename);
        $queryBuilder->where(
            $queryBuilder->expr()
->or($queryBuilder->expr()
        ->eq(
            'verband_id',
            $queryBuilder->createNamedParameter($verbandId, Connection::PARAM_INT)
        ), $queryBuilder->expr()
        ->isNull('verband_id')),
        );
        if ($type !== null) {
            $queryBuilder->andWhere(
                'FIND_IN_SET(' . $queryBuilder->createNamedParameter(
                    $type,
                    Connection::PARAM_STR
                ) . ',invoiceitem_types)'
            );
        }
        return $queryBuilder;
    }
    
    public function findForVerbandType(string $type, int $verbandId = null)
    {
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);

        // Search for given type of invoiceItem
        $queryBuilder = $this->createQueryBuilderByVerbandAndType($verbandId, $type);
        $res = $queryBuilder->executeQuery();
        if ($row = $res->fetchAssociative()) {
            $costCenters = $dataMapper->map(CostCenter::class, [$row]);
            return $costCenters[0];
        }

        
        // Search for default invoiceItem type
        $queryBuilder = $this->createQueryBuilderByVerbandAndType($verbandId, InvoiceItem::class);
        $res = $queryBuilder->executeQuery();
        if ($row = $res->fetchAssociative()) {
            $costCenters = $dataMapper->map(CostCenter::class, [$row]);
            return $costCenters[0];
        }

        // search for any
        $queryBuilder = $this->createQueryBuilderByVerbandAndType($verbandId, null);
        $res = $queryBuilder->executeQuery();
        if ($row = $res->fetchAssociative()) {
            $costCenters = $dataMapper->map(CostCenter::class, [$row]);
            return $costCenters[0];
        }
        return null;
    }

    public function findForVerbandGrouped(int $verbandId = null)
    {
        $costCentersGrouped = [];
        $costCenters = $this->findForVerband($verbandId);
        foreach ($costCenters as $costCenter) {
            $types = GeneralUtility::trimExplode(',', $costCenter->getInvoiceItemTypes(), true);
            foreach ($types as $type) {
                $typename = str_replace('\\', '', $type);
                if (!isset($costCentersGrouped[$typename])) {
                    $costCentersGrouped[$typename] = [];
                }
                $costCentersGrouped[$typename][] = $costCenter;
            }
        }
        //var_dump($costCentersGrouped);exit();
        return $costCentersGrouped;
    }
}
