<?php

namespace Ig\IgFibu\ReferenceFormatter;

class ReferenceFormatterResult
{
    protected ?string $errorMessage = null;
    protected ?string $referenceDebitor = null;
    
    public function __construct(
        protected ?int $invoiceId,
        protected ?int $debitorId,
        protected ?string $format = null,
        protected ?string $tablenames = null
    ) {
    }
    public static function createErrorMessage(string $errorMessage): self
    {
        $referenceFormatterResult = new self(null, null);
        $referenceFormatterResult->setErrorMessage($errorMessage);
        
        return $referenceFormatterResult;
    }

    
    public function isError(): bool
    {
        return $this->errorMessage !== null;
    }
    public function getErrorMessage(): string
    {
        return $this->errorMessage;
    }
    public function setErrorMessage(string $errorMessage): void
    {
        $this->errorMessage = $errorMessage;
    }

    public function getDebitorId(): ?int
    {
        return $this->debitorId;
    }
    public function setDebitorId(?int $debitorId): void
    {
        $this->debitorId = $debitorId;
    }

    public function getReferenceDebitor(): int
    {
        return $this->referenceDebitor;
    }
    public function setReferenceDebitor(int $referenceDebitor): void
    {
        $this->referenceDebitor = $referenceDebitor;
    }
    
    public function getInvoiceId(): ?int
    {
        return $this->invoiceId;
    }
    public function setInvoiceId(?int $invoiceId): void
    {
        $this->invoiceId = $invoiceId;
    }


    public function getFormat(): string
    {
        return $this->format;
    }
    public function setFormat(string $format): void
    {
        $this->format = $format;
    }
    
    public function getTablenames(): string
    {
        return $this->tablenames ?? '';
    }
    public function setTablenames(string $tablenames): void
    {
        $this->tablenames = $tablenames;
    }
}
