<?php

namespace Ig\IgFibu\ViewHelpers\Debitor;

use Closure;
use Ig\IgFibu\Service\DebitorService;
use Internetgalerie\IgCrmTemplate\Domain\Model\TenantInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class NumberViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = true;
    
    public function initializeArguments(): void
    {
        $this->registerArgument('debitor', 'object', 'debitor', true);
        $this->registerArgument('tenant', 'mixed', 'tenant mandant', false, 1);
    }


    public function render(): string
    {
        $debitor = $this->arguments['debitor'];
        $tenant = $this->arguments['tenant'];
        if (!is_object($debitor)) {
            return '';
        }
        if ($tenant instanceof TenantInterface) {
            $useOwnAddressNumber = $tenant->getUseOwnAddressNumber();
        } else {
            $debitorService = GeneralUtility::makeInstance(DebitorService::class);
            $tenant = $debitorService->getMandantByUid((int)$tenant);
            if ($tenant instanceof TenantInterface) {
                $useOwnAddressNumber = $tenant->getUseOwnAddressNumber();
            } else {
                $useOwnAddressNumber = false;
            }
        }

        if ($useOwnAddressNumber) {
            return $debitor->getNumber();
            //return $debitor->getOwnNumber();
        }
        return $debitor->getUid();
    }
}
