<?php

namespace Ig\IgFibu\ViewHelpers\Tenant;

use Closure;
use Ig\IgFibu\Service\DebitorService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'tenant uid', true);
        $this->registerArgument('as', 'string', 'name for tenant object ', true);
    }

    public function render(): string
    {
        $tenantUid = $this->arguments['uid'];
        $debitorService = GeneralUtility::makeInstance(DebitorService::class);
        $tenant = $debitorService->getMandantByUid($tenantUid);
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $tenant);
        $output =  $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
