<?php

use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Model\InvoiceItemUnit;

return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter',
        'label' => 'title',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'sortby' => 'sorting',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
        ],
        'searchFields' => 'verband_id,code,title, invoiceitem_types, invoice_attribute',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_costcenter.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, hidden, verband_id, code, title, invoiceitem_types, invoice_attribute, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access'],
    ],
    'columns' => [
        'hidden' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],

        'verband_id' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter.verband_id',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'nullable' => true
            ]
        ],
        'code' => [
            'exclude' => true,
            'l10n_mode' => 'exclude',
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter.code',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'invoice_attribute' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter.invoice_attribute',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],

        'invoiceitem_types' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_costcenter.invoiceitem_types',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectCheckBox',
                'items' => [
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.type.invoiceitem', 'value' => InvoiceItem::class ],
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoiceitem.type.invoiceitem_unit', 'value' => InvoiceItemUnit::class ],
                ],
                'default' => InvoiceItem::class,
                'minitems' => 0,
                'maxitems' => 5,
                'nullable' => true,
            ],
        ],

        
    ],
];
