<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit',
        'label' => 'tenant_id',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'delete' => 'deleted',
        'enablecolumns' => [
        ],
        'searchFields' => 'title',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_credit.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'is_done, tenant_id, debitor_id, title, amount, due_date, create_date, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igfibu_domain_model_credit',
                'foreign_table_where' => 'AND {#tx_igfibu_domain_model_credit}.{#pid}=###CURRENT_PID### AND {#tx_igfibu_domain_model_credit}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        'tenant_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.tenant_id',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'default' => 0
            ]
        ],
        'debitor_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.debitor_id',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'default' => 0
            ]
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'default' => ''
            ],
        ],
        'amount' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.amount',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'due_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.due_date',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'create_date' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_credit.create_date',
            'config' => [
                'dbType' => 'datetime',
                'type' => 'datetime',
                'size' => 12,
                'default' => null,
            ],
        ],
        'is_done' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.is_done',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
    
    ],
];
