<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment',
        'label' => 'verband_id',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'delete' => 'deleted',
        'searchFields' => 'verband_id,entry_id,debitor_id, tablenames,betrag,amount_applied, charges,iban,is_ok,is_done,text_info,debitor_organisation,debitor_address,date_pay,date_valuta,date_import,reference,reference_bank,reference_entry,reference_invoice,is_missing,invoice,import',
        'iconfile' => 'EXT:ig_fibu/Resources/Public/Icons/tx_igfibu_domain_model_payment.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'verband_id, entry_id, debitor_id, tablenames, betrag, amount_applied, charges, iban, is_ok, is_done, text_info, debitor_organisation, debitor_address, date_pay, date_valuta, date_import, reference, reference_bank, reference_entry, reference_invoice, is_missing, invoice, import'],
    ],
    'columns' => [
        'verband_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.verband_id',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'entry_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.entry_id',
            'config' => [
                'type' => 'number',
                'size' => 4
            ]
        ],
        'debitor_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.debitor_id',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'nullable' => true
            ]
        ],
        'tablenames' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.tablenames',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
        'betrag' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.betrag',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'amount_applied' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.amount_applied',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'default' => '0',
                'format' => 'decimal',
            ]
        ],
        'charges' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.charges',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'format' => 'decimal'
            ]
        ],
        'iban' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.iban',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ]
        ],
        'is_ok' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.is_ok',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'is_done' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.is_done',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'text_info' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.text_info',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'debitor_organisation' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.debitor_organisation',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'debitor_address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.debitor_address',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],
        'date_pay' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.date_pay',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'date_valuta' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.date_valuta',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'date_import' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.date_import',
            'config' => [
                'dbType' => 'date',
                'type' => 'datetime',
                'size' => 7,
                'default' => null,
                'format' => 'date',
            ],
        ],
        'reference' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.reference',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'reference_bank' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.reference_bank',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'reference_format' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.reference_format',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'reference_entry' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.reference_entry',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'reference_invoice' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.reference_invoice',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'is_missing' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.is_missing',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'invoice' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.invoice',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igfibu_domain_model_invoice',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'import' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_payment.import',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igfibu_domain_model_paymentimport',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
    
    ],
];
