document.querySelector('.print-page-link')?.addEventListener('click',function(e){
    window.print();
});

document.querySelectorAll('.ajax-call').forEach((ajaxCall, i) => {
    ajaxCall.addEventListener('click', function(e){
	e.preventDefault();
	let undo =  this.getAttribute('data-undo');
	let url = this.getAttribute('data-uri') + "?" + this.getAttribute('data-arguments') + (undo ? '&undo=' + undo : '');
	let addClass = this.getAttribute('data-add-class');
	let removeClass = this.getAttribute('data-remove-class');
	let el = this;
	let elementToShow = document.querySelector(this.getAttribute('data-element-to-show'));
	//console.log(url);
	fetch(url)
	    .then((response) => {
		if (response.ok) {
		    return response.json();
		}
		throw new Error('Network response was not OK');
	    })
	    .then((data) => {
		if (removeClass) {
		    el.classList.remove(removeClass);
		}
		if (addClass) {
		    el.classList.add(addClass);
		}
		el.style.display = 'none';
		elementToShow.style.display = 'block';
	    })
	    .catch((error) => {
		console.error("Error:", error);
	    });
    });
});

var downloadPdf = function(pdfContent, filename, successFunction ) {
		fetch("data:application/pdf;base64," + pdfContent)
		    .then((response) => response.blob())
		    .then((blob) => {
			let newBlob = new Blob([blob], {type: "application/pdf"});
			const objectUrl = window.URL.createObjectURL(newBlob);
			let link = document.createElement('a');
			link.href = objectUrl;
			link.download = filename;
			link.click();
			/*
			setTimeout(function(){
			    // For Firefox it is necessary to delay revoking the ObjectURL
			    window.URL.revokeObjectURL(objectUrl);
			}, 100);
			*/
			successFunction(objectUrl);
		    });
};

document.querySelectorAll('.ajax-pdf-call').forEach((ajaxCall, i) => {
    ajaxCall.addEventListener('click', function ajaxEventFunc(e){
	e.preventDefault();
	let linkElement = this;
	let page = i + 1;
	let elementFilename = document.getElementById('ig-fibu-filename');
	let url = this.getAttribute('data-uri') + "?" + this.getAttribute('data-arguments') + "&page=" + page;
	let spinner = this.querySelector('.spinner');
	let textCreate = this.querySelector('.text-create');
	let textDownload = this.querySelector('.text-download');
	let id = this.getAttribute('data-id');
	let setButton = document.querySelector('#set-' + id);
	if (elementFilename.value) {
	    url += "&additionalFilename=" + encodeURIComponent(elementFilename.value);
	}
	spinner.style.display = 'inline';
	textCreate.style.display = 'none';
	
	fetch(url)
	    .then((response) => {
		if (response.ok) {
		    return response.text();
		}
		throw new Error('Network or Server Problem');
	    })
	    .then((responseData) => {
		let data;
		try {
		    data = JSON.parse(responseData);
		} catch (error) {
		    //console.error('JSON.parse() Error:', error);
		    throw new Error('Error parsing JSON data');
		}
		downloadPdf(data.pdf, data.filename, function(objectUrl) {
		    spinner.style.display = 'none';
		    textDownload.style.display = 'inline';
		    setButton.classList.add('crm-button-ok');
		    setButton.classList.remove('crm-button-danger');
		    linkElement.href = objectUrl;
		    linkElement.download = data.filename;
		    linkElement.removeEventListener('click', ajaxEventFunc);
		    if (data.debitorErrorCount > 0) {
			toastr.options.timeOut = 0;// Show errors forever
			toastr.error(data.debitorErrorCount + ' Debitor Adressen sind unvollständigen', 'Achtung');
			//toastr.["warning"]("Achtung", data.debitorErrorCount + ' Debitor Adressen sind unvollständigen');
			//alert('Achtung: ' + data.debitorErrorCount + ' Debitor Adressen sind unvollständigen');
		    } else {
			addMerge(data.pdf);
		    }
		});
	    })
	    .catch((error) => {
		toastr.options.timeOut = 0;// Show errors forever
		toastr.error(error.message, 'PDF-Erstellung fehlgeschlagen');
		//alert("PDF-Erstellung fehlgeschlagen: " + error.message);
		spinner.style.display = 'none';
		textCreate.style.display = 'inline';
	    });



    });
});
document.querySelector('.ajax-pdf-all-call').addEventListener('click', function ajaxEventFunc(e){
    e.preventDefault();
    let max = 20;
    let delayinMs = 60000; // 1min
    let delay = 0;
    document.querySelectorAll('.ajax-pdf-call').forEach((el, i) => {
	if (max > 0 && el.querySelector('.text-create').style.display !== 'none') {
	    setTimeout(function() {
		el.click();
	    }, delay);
	    delay += delayinMs;
	    max--;
	}
    });
});

var mergedPdf = null;
var mergedFiles = document.querySelectorAll('.ajax-pdf-call').length;
var addMerge = async function(dataPdf) {
    let PDFDocument = PDFLib.PDFDocument;
    const addPdf = await PDFDocument.load(dataPdf);
    if (!mergedPdf) { 
	mergedPdf = await PDFLib.PDFDocument.create();
    }
    const copiedPagesAddPdf = await mergedPdf.copyPages(addPdf, addPdf.getPageIndices());
    copiedPagesAddPdf.forEach((page) => mergedPdf.addPage(page));
    mergedFiles--;
    if (mergedFiles == 0) {
	document.querySelector('.ajax-pdf-all-call').style.display = 'none';
	document.querySelector('.ajax-pdf-all-download').style.display = 'block';
    }
}

document.querySelector('.ajax-pdf-all-download').addEventListener('click', async function ajaxEventFunc(e){
    const mergedPdfFile = await mergedPdf.save();
    let link = document.createElement('a');
    link.download = 'Rechnungen-all.pdf';
    link.href = window.URL.createObjectURL(new Blob([mergedPdfFile], {type: "application/pdf"}))
    link.click();
});
