<?php

declare(strict_types=1);

namespace Ig\IgFibu\Controller;

use Ig\IgFibu\Domain\Model\InvoicePayment;
use Ig\IgFibu\Service\BookingService;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Messaging\FlashMessage;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoicePaymentController extends AbstractFibuController
{
    /**
     * flashMessageIdentifier
     *
     * @var string
     */
    protected $flashMessageIdentifier = 'extbase.flashmessages.tx_igcrmadmin_re';

    /**
     * action book credit with invoice
     */
    public function unbookAction(InvoicePayment $invoicePayment): ResponseInterface
    {
        $invoice = $invoicePayment->getInvoice();
        $payment = $invoicePayment->getPayment();
        if ($invoicePayment->getCanUndo()) {
            $bookingService = GeneralUtility::makeInstance(BookingService::class);
            $bookingService->setSettings($this->settings);
            $unbooked = $bookingService->unbook($invoicePayment);
            if ($invoicePayment->getUndoDeleteCredit()) {
                $message = GeneralUtility::makeInstance(
                    FlashMessage::class,
                    'Gutschrift wurde gelöscht.',
                    '',
                    ContextualFeedbackSeverity::OK,
                    true
                );
                $this->flashMessageService->getMessageQueueByIdentifier($this->flashMessageIdentifier)
->enqueue($message);
            }


            if ($unbooked) {
                $message = GeneralUtility::makeInstance(
                    FlashMessage::class,
                    'Buchung wurde rückgängig gemacht.',
                    '',
                    ContextualFeedbackSeverity::OK,
                    true
                );
            } else {
                $message = GeneralUtility::makeInstance(
                    FlashMessage::class,
                    'Buchung kann nicht rückgängig gemacht werden.',
                    '',
                    ContextualFeedbackSeverity::ERROR,
                    true
                );
            }
        } else {
            $message = GeneralUtility::makeInstance(
                FlashMessage::class,
                'Buchung kann nicht rückgängig gemacht werden.',
                '',
                ContextualFeedbackSeverity::ERROR,
                true
            );
        }
        $this->flashMessageService->getMessageQueueByIdentifier($this->flashMessageIdentifier)
->enqueue($message);
        if ($invoice) {
            return $this->redirectToInvoiceShow($invoice, 'payments');
        }
        return $this->redirectToPaymentShow($payment);
    }

    protected function redirectToInvoiceShow($invoice, $activeTab): ResponseInterface
    {
        $this->uriBuilder
            ->reset()
            ->setRequest($this->request)
            ->setTargetPageUid((int)$this->settings['invoicePid']);
        $uri = $this->uriBuilder->uriFor(
            'show',
            [
                'invoice' => $invoice->getUid(),
                'activeTab' => $activeTab,
            ],
            'Invoice',
            null,
            'Re'
        );
        return $this->redirectToUri($uri);
    }
    protected function redirectToPaymentShow($payment): ResponseInterface
    {
        $this->uriBuilder
            ->reset()
            ->setRequest($this->request)
            ->setTargetPageUid((int)$this->settings['paymentPid']);
        $uri = $this->uriBuilder->uriFor('show', [
            'payment' => $payment->getUid(),
        ], 'Payment', null, 'Za');
        return $this->redirectToUri($uri);
    }
}
