<?php

namespace Ig\IgFibu\Controller;

use Ig\IgFibu\Domain\Repository\LogMailRepository;
use Ig\IgFibu\Service\DebitorService;
use Internetgalerie\IgDoctrinePaginator\Pagination\DoctrinePaginator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class LogMailController extends ActionController
{
    /**
     * logMailRepository
     *
     * @var LogMailRepository
     */
    protected $logMailRepository = null;

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;

    /**
     * debitor: Join Config, Attributes for search and display debitor infos (name)
     *
     * @var array
     */
    protected $debitorConf = [];
    /*
      [
        'joinTable' => 'tx_igscrm_domain_model_contact',
        'joinAttribute' => 'uid',
        'displayAttribute' => ['me_companyname', 'me_firstname', 'me_lastname'], // space separated
        'searchAttribute' => ['me_companyname', 'me_firstname', 'me_lastname'],
    ];
    */
    
    
    public function injectLogMailRepository(LogMailRepository $logMailRepository): void
    {
        $this->logMailRepository = $logMailRepository;
    }
    
    
    public function injectDebitorService(DebitorService $debitorService): void
    {
        $this->debitorService = $debitorService;
    }

    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = $this->getSearch();
        //$conf = $this->debitorService->getConfig('Person');

        $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument('currentPage') : 1;
        $this->debitorConfig = $this->debitorService->getDebitorConfig();
        
        //$page = $this->request->hasArgument('page') ? (int) $this->request->getArgument('page') : 1;
        //$queryBuilderLogMails = $this->logMailRepository->queryBuilderBySearch($search, $this->debitorConfig);
        $queryBuilderLogMails = $this->logMailRepository->getQueryBuilderBySearch($search);
        $paginator = new DoctrinePaginator($queryBuilderLogMails, $currentPage, 50);
        $pagination = $paginator->createSlidingWindowPagination(10);
 
        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);
        $logMails = $this->logMailRepository->paginationProccessResult($paginator);
                  
        //$logMails = $this->logMailRepository->findBySearch($search, $this->debitorConfig);
        $this->view->assign('search', $search);
        $this->view->assign('config', $this->debitorService->getAllConfig()); // Fuer Debitor Link
        $this->view->assign('debitorConfig', $this->debitorConfig);// Fuer Anzeige
        $this->view->assign('logMails', $logMails);
        return $this->htmlResponse($this->view->render());
    }

    protected function getSearch()
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        $verbandsUids = [];
        if ($this->settings['mandant']['active'] ?? false) {
            $this->verbandRepository = GeneralUtility::makeInstance($this->settings['mandant']['repository']);
            $verbands = $this->verbandRepository->findAllWithAcl(true);
            foreach ($verbands as $verband) {
                $verbandsUids[] = (int) $verband['uid'];
            }
        }
        if (!empty($verbandsUids)) {
            $searchVerbandsUids = [];
            if (!empty($search['verband'] ?? [])) {
                if (is_array($search['verband'])) {
                    $searchVerbandsUids = array_intersect($verbandsUids, $search['verband']);
                } else {
                    if (in_array((int) $search['verband'], $verbandsUids)) {
                        $searchVerbandsUids = [(int) $search['verband']];
                    } else {
                        $searchVerbandsUids = $verbandsUids;
                    }
                }
            } else {
                //$search['verband'] = $verbandsUids[0];
                $searchVerbandsUids = [$verbandsUids[0]];
            }
        } else {
            $searchVerbandsUids = [0];
        }
        return $search;
    }
}
