<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

use Ig\IgFibu\Service\DebitorService;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class LogMailQueryBuilder extends BaseQueryBuilder
{
    protected $tablename = 'tx_igfibu_domain_model_log_mail';

    protected $entryTablename = null;
    protected $entryPrimaryKey = 'uid';

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;


    
    public function injectDebitorService(DebitorService $debitorService): void
    {
        $this->debitorService = $debitorService;
    }

    public function resetSelect()
    {
        $this->sqlSelect = '*';
        return $this;
    }

    public function setEntryTablename($entryTablename)
    {
        $this->entryTablename = $entryTablename;
        return $this;
    }

    public function getEntryTablename()
    {
        return $this->entryTablename;
    }

    public function setEntryPrimaryKey($entryPrimaryKey)
    {
        $this->entryPrimaryKey = $entryPrimaryKey;
        return $this;
    }

    public function getEntryPrimaryKey()
    {
        return $this->entryPrimaryKey;
    }

    public function addSearch($search)
    {
        $constraints = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constraints[] = $this->expr()->eq(
                $this->tablename . '.uid',
                $this->createNamedParameter(trim((string) $search['uid']), Connection::PARAM_INT)
            );
        }
        

        if (isset($search['keywords'])) {
            $keywordsArray = GeneralUtility::trimExplode(' ', $search['keywords'], true);
            if (!empty($keywordsArray)) {
                foreach ($keywordsArray as $keyword) {
                    $keywordConstraints = $this->debitorService->getDebitorKeywordConstraints($this, $keyword);
                    $keywordConstraints[] = $this->expr()->like(
                        'lm_mail_to',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $keywordConstraints[] = $this->expr()->like(
                        'lm_periode_name',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    $keywordConstraints[] = $this->expr()->like(
                        'lm_invoice_re_id',
                        $this->createNamedParameter('%' . $keyword . '%')
                    );
                    
                    $constraints[] = $this->expr()->or(...$keywordConstraints);
                }
            }
        }
        if (isset($search['verband']) && $search['verband']) {
            $constraints[] = $this->expr()->eq('verband_id', (int) $search['verband']);
        }
        if (isset($search['language']) && $search['language']) {
            $constraints[] = $this->expr()->eq('lm_language', (int) $search['language']);
        }
        //        var_dump($subConstraints, $search);exit(0);
        /* @todo add event for PEDOS */
        $betK = isset($search['bet_k']) && $search['bet_k'] != '' ? $search['bet_k'] : false;
        $betB = isset($search['bet_b']) && $search['bet_b'] != '' ? $search['bet_b'] : false;
        $betA = isset($search['bet_a']) && $search['bet_a'] != '' ? $search['bet_a'] : false;
        if (isset($search['betrieb'])) {
            $betK = substr((string) $search['betrieb'], 0, 1);
            $betB = substr((string) $search['betrieb'], 1, 4);
            $betA = substr((string) $search['betrieb'], 5, 2);
        }
        if ($betK !== false) {
            $constraints[] = $this->expr()->eq('bet_k', $this->createNamedParameter($betK));
        }
        if ($betB !== false) {
            $constraints[] = $this->expr()->eq('bet_b', $this->createNamedParameter($betB));
        }
        if ($betA !== false) {
            $constraints[] = $this->expr()->eq('bet_a', $this->createNamedParameter($betA));
        }


        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
}
