<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use Ig\IgFibu\Domain\Repository\InvoicePaymentRepository;
use Ig\IgFibu\Service\DebitorService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Credit extends AbstractEntity implements FibuAclInterface
{
    /**
     * tenantId
     *
     * @var int
     */
    protected $tenantId = 0;

    /**
     * debitorId
     *
     * @var int
     */
    protected $debitorId = 0;

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * amount
     *
     * @var float
     */
    protected $amount = 0.0;

    /**
     * dueDate
     *
     * @var DateTime
     */
    protected $dueDate = null;

    /**
     * createDate
     *
     * @var DateTime
     */
    protected $createDate = null;

    /**
     * isDone
     *
     * @var bool
     */
    protected $isDone = false;

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;

    /**
     * debitor
     *
     * @var object
     */
    protected $debitor = false;

    /**
     * invoicePayments
     *
     * @var array
     */
    protected $invoicePayments = null;


    public function __construct()
    {
        $this->createDate = new DateTime();
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    public function getAmountClass(): string
    {
        if ($this->amount === 0.0) {
            return 'null';
        }
        if ($this->amount > 0.0) {
            return 'positive';
        }
        return 'negative';
    }

    /**
     * Sets the amount
     */
    public function setAmount(float $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns the dueDate
     *
     * @return DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * Sets the dueDate
     */
    public function setDueDate(DateTime $dueDate = null): void
    {
        $this->dueDate = $dueDate;
    }


    /**
     * Returns the createDate
     *
     * @return DateTime
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }

    /**
     * Sets the createDate
     */
    public function setCreateDate(DateTime $createDate): void
    {
        $this->createDate = $createDate;
    }

    /**
     * Returns the isDone
     *
     * @return bool
     */
    public function getIsDone()
    {
        return $this->isDone;
    }

    /**
     * Sets the isDone
     *
     * @param  bool $isDone
     */
    public function setIsDone($isDone): void
    {
        $this->isDone = $isDone;
    }

    /**
     * Returns the boolean state of isDone
     *
     * @return bool
     */
    public function isIsDone()
    {
        return $this->isDone;
    }
    public function getStatus()
    {
        if ($this->getIsDone()) {
            $class = 'ig-fibu-status';
            $style = 'background-color: #00aa00; color: #ffffff;';
            $title = 'Verbucht';
        } else {
            $class = 'ig-fibu-status';
            $style = 'background-color: #00aaaa; color: #ffffff;';
            $title = 'Offen';
        }
        return [
            'class' => $class,
            'style' => $style,
            'title' => $title,
        ];
    }

    
    /**
     * Returns the tenantId
     */
    public function getTenantId(): ?int
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the debitorId
     *
     * @return int debitorId
     */
    public function getDebitorId()
    {
        return $this->debitorId;
    }

    /**
     * Sets the debitorId
     */
    public function setDebitorId(int $debitorId): void
    {
        $this->debitorId = $debitorId;
    }


    /**
     * Get Debitor Object
     */
    public function getDebitor()
    {
        if ($this->debitor === false) {
            $modelClassName = $this->getDebitorService()
->getModelClassName('default');
            if ($modelClassName) {
                $repositoryClassName = $this->getDebitorService()
->getRepositoryClassName('default');
                if ($repositoryClassName) {
                    $repository = GeneralUtility::makeInstance($repositoryClassName);
                    $this->debitor = $repository->findByUid($this->debitorId);
                } else {
                    $this->debitor = null;
                }
            } else {
                $this->debitor = null;
            }
        }
        return $this->debitor;
    }
    /**
     * @return DebitorService
     */
    public function getDebitorService()
    {
        if ($this->debitorService === null) {
            $this->debitorService = GeneralUtility::makeInstance(DebitorService::class);
        }
        return $this->debitorService;
    }
    /**
     * Get invoicePayment with this Credit
     */
    public function getInvoicePayments()
    {
        if ($this->invoicePayments === null) {
            $invoicePaymentRepository = GeneralUtility::makeInstance(InvoicePaymentRepository::class);
            $this->invoicePayments = $invoicePaymentRepository->findBy([
                'credit' => $this->uid,
            ])
->toArray();
        }
        return $this->invoicePayments;
    }
    public function getCanDelete(): bool
    {
        $invoicePayments = $this->getInvoicePayments();
        $count = count($invoicePayments);
        return $count == 0 && !$this->getIsDone();
    }
}
