<?php

namespace Ig\IgFibu\Domain\Model;

use Internetgalerie\IgCrmTemplate\Domain\Model\TenantInterface;
use Internetgalerie\IgDatapoolFe\Utility\FormUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;

/**
 * address
 */
class Creditor extends Address implements ClientInterface, TenantInterface
{
    /**
     * nameHr
     *
     * @var string
     */
    protected $nameHr = '';

    /**
     * bankingCustomerIdentification
     *
     * @var string
     */
    protected $bankingCustomerIdentification = '';

    /**
     * iban
     *
     * @var string
     */
    protected $iban = '';

    /**
     * qrIban
     *
     * @var string
     */
    protected $qrIban = '';

    /**
     * invoiceFromEmail
     *
     * @var string
     */
    protected $invoiceFromEmail = '';

    /**
     * invoiceFromName
     *
     * @var string
     */
    protected $invoiceFromName = '';

    /**
     * invoiceTestEmail
     *
     * @var string
     */
    protected $invoiceTestEmail = '';

    /**
     * invoiceBccEmail
     *
     * @var string
     */
    protected $invoiceBccEmail = '';

    /**
     * taxBehavior (0 = inkl., 1 = exkl)
     *
     * @var int
     */
    protected $taxBehavior = null;

    /**
     * taxRate
     *
     * @var float
     */
    protected $taxRate = null;

    /**
     * referenceFormatterClass
     *
     * @var string
     */
    protected $referenceFormatterClass = null;


    /**
     * invoicePeriodeLengthInMonth
     *
     * @var int
     */
    protected $invoicePeriodeLengthInMonth;

    /**
     * logo
     */
    protected ?FileReference $logo = null;

    /**
     * layout/template
     *
     * @var array
     */
    protected $layout = [];

    /**
     * getUseOwnAddressNumber
     *
     * @var bool
     */
    protected $useOwnAddressNumber = false;
    
    /**
     * invoiceCss
     *
     * @var string
     */
    protected $invoiceCss = '';

    public function setArray(array $data): void
    {
        parent::setArray($data);
        $this->setBankingCustomerIdentification($data['bankingCustomerIdentification'] ?? '');
        $this->setIban($data['iban'] ?? '');
        $nameHr = $data['nameHr'] ?? '';
        $this->setNameHr($nameHr ?: $data['name'] ?? '');
        $this->setQrIban($data['qrIban'] ?? '');
        $this->setReferenceFormatterClass($data['referenceFormatterClass'] ?? null);
        $this->setInvoiceCss($data['invoiceCss'] ?? '');
        $this->setInvoiceFromEmail($data['invoiceFromEmail'] ?? '');
        $this->setInvoiceFromName($data['invoiceFromName'] ?? '');
        $this->setInvoiceBccEmail($data['invoiceBccEmail'] ?? '');
        $this->setInvoiceTestEmail($data['invoiceTestEmail'] ?? '');
        $this->setInvoicePeriodeLengthInMonth((int) $data['invoicePeriodeLengthInMonth'] ?? 0);
        $this->setLayout($data['layout'] ?? []);
        if ($data['taxRate']) {
            $this->setTaxRate($data['taxRate']);
        }
        if (isset($data['taxBehavior'])) {
            $this->setTaxBehavior($data['taxBehavior']);
        }
        if (isset($data['useOwnAddressNumber'])) {
            $this->setUseOwnAddressNumber($data['useOwnAddressNumber']);
        }
        if (isset($data['logo'])) {
            $this->formUtility = GeneralUtility::makeInstance(FormUtility::class);
            $logoFile = $this->formUtility->retrieveFileOrFolderObject($data['logo']);
            $logoFileReference = $this->formUtility->createFileReferenceFromFileResourceObject($logoFile);
            if ($logoFileReference  instanceof FileReference) {
                $this->setLogo($logoFileReference);
            }
        }
        //$this->set($data[''] ?? '');
        //$this->setUid(0);
    }
    

    /**
     * Returns the nameHr
     *
     * @return string
     */
    public function getNameHr()
    {
        return $this->nameHr;
    }
    public function getName()
    {
        return $this->nameHr;
    }


    /**
     * Sets the nameHr
     *
     * @param string $nameHr
     */
    public function setNameHr($nameHr): void
    {
        $this->nameHr = $nameHr;
    }

    /**
     * Returns the bankingCustomerIdentification
     *
     * @return string
     */
    public function getBankingCustomerIdentification()
    {
        return $this->bankingCustomerIdentification;
    }

    /**
     * Sets the bankingCustomerIdentification
     *
     * @param string $bankingCustomerIdentification
     */
    public function setBankingCustomerIdentification($bankingCustomerIdentification): void
    {
        $this->bankingCustomerIdentification = $bankingCustomerIdentification;
    }


    /**
     * Returns the iban
     *
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }

    /**
     * Sets the iban
     *
     * @param string $iban
     */
    public function setIban($iban): void
    {
        $this->iban = $iban;
    }

    /**
     * Returns the qrIban
     *
     * @return string
     */
    public function getQrIban()
    {
        return $this->qrIban;
    }

    /**
     * Sets the qrIban
     *
     * @param string $qrIban
     */
    public function setQrIban($qrIban): void
    {
        $this->qrIban = $qrIban;
    }


    /**
     * Returns the referenceFormatterClass
     */
    public function getReferenceFormatterClass(): ?string
    {
        return $this->referenceFormatterClass;
    }

    /**
     * Sets the referenceFormatterClass
     */
    public function setReferenceFormatterClass(?string $referenceFormatterClass): void
    {
        $this->referenceFormatterClass = $referenceFormatterClass;
    }
    
    /**
     * Get the value of invoiceCss
     *
     * @return string
     */
    public function getInvoiceCss()
    {
        return $this->invoiceCss;
    }

    /**
     * Set the value of invoiceCss
     *
     * @param string $invoiceCss
     *
     * @return self
     */
    public function setInvoiceCss($invoiceCss)
    {
        $this->invoiceCss = $invoiceCss;

        return $this;
    }

    /**
     * Returns the invoiceFromName
     *
     * @return string
     */
    public function getInvoiceFromName()
    {
        return $this->invoiceFromName;
    }

    /**
     * Sets the invoiceFromName
     *
     * @param string $invoiceFromName
     */
    public function setInvoiceFromName($invoiceFromName): void
    {
        $this->invoiceFromName = $invoiceFromName;
    }

    /**
     * Returns the invoiceFromEmail
     *
     * @return string
     */
    public function getInvoiceFromEmail()
    {
        return $this->invoiceFromEmail;
    }

    /**
     * Sets the invoiceFromEmail
     *
     * @param string $invoiceFromEmail
     */
    public function setInvoiceFromEmail($invoiceFromEmail): void
    {
        $this->invoiceFromEmail = $invoiceFromEmail;
    }

    /**
     * Returns the invoiceToEmail
     *
     * @return string
     */
    public function getInvoiceEmail()
    {
        return $this->invoiceFromEmail;
    }

    /**
     * Returns the invoiceTestEmail
     *
     * @return string
     */
    public function getInvoiceTestEmail()
    {
        return $this->invoiceTestEmail;
    }

    /**
     * Sets the invoiceTestEmail
     *
     * @param string $invoiceTestEmail
     */
    public function setInvoiceTestEmail($invoiceTestEmail): void
    {
        $this->invoiceTestEmail = $invoiceTestEmail;
    }

    /**
     * Returns the invoiceBccEmail
     *
     * @return string
     */
    public function getInvoiceBccEmail()
    {
        return $this->invoiceBccEmail;
    }

    /**
     * Sets the invoiceBccEmail
     *
     * @param string $invoiceBccEmail
     */
    public function setInvoiceBccEmail($invoiceBccEmail): void
    {
        $this->invoiceBccEmail = $invoiceBccEmail;
    }



    /**
     * Returns the invoicePeriodeLengthInMonth
     *
     * @return int
     */
    public function getInvoicePeriodeLengthInMonth()
    {
        return $this->invoicePeriodeLengthInMonth;
    }

    /**
     * Sets the invoicePeriodeLengthInMonth
     *
     * @param int $invoicePeriodeLengthInMonth
     */
    public function setInvoicePeriodeLengthInMonth($invoicePeriodeLengthInMonth): void
    {
        $this->invoicePeriodeLengthInMonth = $invoicePeriodeLengthInMonth;
    }

    

    /**
     * Returns the layout
     *
     * @return array
     */
    public function getLayout()
    {
        return $this->layout;
    }
    
    /**
     * Sets the layout
     */
    public function setLayout(array $layout): void
    {
        $this->layout = $layout;
    }


    /*
    public function getTemplateLetter(string $templateType, $contact, Invoice $invoice = null)
    {
        $name = lcfirst($templateType);
        $layout = $this->getLayout();
        return $layout[$name] ?? $layout['default'];
    }
    */
    
    /**
     * Returns the taxRate
     *
     * @return float
     */
    public function getTaxRate()
    {
        return $this->taxRate;
    }

    /**
     * Sets the taxRate
     *
     * @param  float $taxRate
     */
    public function setTaxRate($taxRate): void
    {
        $this->taxRate = $taxRate;
    }

    /**
     * Returns the taxBehavior
     *
     * @return int
     */
    public function getTaxBehavior()
    {
        return $this->taxBehavior;
    }
    public function getTaxBehaviorIsInkl()
    {
        return $this->taxBehavior === Invoice::TAXBEHAVIOR_INKL;
    }
    public function getTaxBehaviorIsExkl()
    {
        return $this->taxBehavior === Invoice::TAXBEHAVIOR_EXKL;
    }
    public function getTaxBehaviorIsUnspecified()
    {
        return $this->taxBehavior === null;
    }

    /**
     * Sets the taxBehavior
     */
    public function setTaxBehavior(int $taxBehavior = null): void
    {
        $this->taxBehavior = $taxBehavior;
    }

    /**
     * Returns the logo
     */
    public function getLogo(): ?FileReference
    {
        return $this->logo;
    }

    /**
     * Sets the logo
     */
    public function setLogo(?FileReference $logo = null): void
    {
        $this->logo = $logo;
    }
    
    /**
     * Returns the useOwnAddressNumber
     */
    public function getUseOwnAddressNumber(): bool
    {
        return $this->useOwnAddressNumber;
    }

    /**
     * Sets the useOwnAddressNumber
     */
    public function setUseOwnAddressNumber(bool $useOwnAddressNumber): void
    {
        $this->useOwnAddressNumber = $useOwnAddressNumber;
    }
}
