<?php

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * Interface of a view
 */
interface InvoiceInterface
{
    /**
     * Returns the type
     */
    public function getType(): string;

    /**
     * Sets the type
     */
    public function setType(string $type): void;

    /**
     * Returns the position
     *
     * @return string
     */
    public function getPosition();

    /**
     * Sets the position
     *
     * @param  string $position
     */
    public function setPosition($position);

    /**
     * Returns the periode
     *
     * @return string
     */
    public function getPeriode();
    public function getLastPeriode();

    /**
     * Sets the periode
     *
     * @param  string $periode
     */
    public function setPeriode($periode);

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription();

    /**
     * Sets the description
     *
     * @param  string $description
     */
    public function setDescription($description);
    
    /**
     * Returns the mode
     *
     * @return int
     */
    public function getMode();

    /**
     * Sets the mode
     *
     * @param  int $mode
     */
    public function setMode($mode);

    /**
     * Returns the createDate
     *
     * @return DateTime
     */
    public function getCreateDate();

    /**
     * Sets the createDate
     */
    public function setCreateDate(DateTime $createDate);

    /**
     * Returns the invoiceDate
     *
     * @return DateTime
     */
    public function getInvoiceDate();

    /**
     * Sets the invoiceDate
     */
    public function setInvoiceDate(DateTime $invoiceDate);

    /**
     * Returns the paidDate
     *
     * @return DateTime
     */
    public function getPaidDate();

    /**
     * Sets the paidDate
     */
    public function setPaidDate(DateTime $paidDate);

    /**
     * Returns the mwst
     */
    public function getTaxRate(): float;

    /**
     * Sets the mwst
     */
    public function setTaxRate(float $taxRate): void;

    public function getRoundingStep(): float;
    public function setRoundingStep(float $roundingStep): void;

    
    /**
     * Returns the totalExkl
     *
     * @return float
     */
    public function getTotalExkl();
    /**
     * Returns the totalInkl
     *
     * @return float
     */
    public function getTotalInkl();

    /**
     * Sets the totalExkl
     *
     * @param  float $totalExkl
     */
    public function setTotalExkl($totalExkl);

    /**
     * Returns the total
     *
     * @return float
     */
    public function getTotal();
    
    /**
     * Sets the total
     *
     * @param  float $total
     */
    public function setTotal($total);

    /**
     * Returns the letterDate
     *
     * @return DateTime
     */
    public function getLetterDate();

    /**
     * Sets the letterDate
     */
    public function setLetterDate(DateTime $letterDate);

    /**
     * Returns the status
     *
     * @return Invoicestatus
     */
    public function getStatus();

    /**
     * Sets the status
     */
    public function setStatus(Invoicestatus $status);

    /**
     * Returns the art
     *
     * @return Invoicescheme
     */
    public function getArt();

    /**
     * Sets the art
     */
    public function setArt(Invoicescheme $art);

    /**
     * Adds a InvoiceItem
     */
    public function addInvoiceItem(InvoiceItem $invoiceitem);

    /**
     * Removes a InvoiceItem
     *
     * @param InvoiceItem $invoiceitemToRemove The InvoiceItem to be removed
     */
    public function removeInvoiceItem(InvoiceItem $invoiceitemToRemove);

    /**
     * Returns the invoiceitems
     *
     * @return ObjectStorage<InvoiceItem> invoiceitem
     */
    public function getInvoiceItems();
    
    /**
     * Sets the invoiceitem
     *
     * @param ObjectStorage<InvoiceItem> $invoiceitem
     */
    public function setInvoiceItem(ObjectStorage $invoiceitem);

    /**
     * Returns the entryId
     *
     * @return int entryId
     */
    public function getEntryId();
    public function getEntryUId();

    /**
     * Sets the entryId
     *
     * @param  string $entryId
     */
    public function setEntryId($entryId);

    /**
     * Returns the tablenames
     *
     * @return string
     */
    public function getTablenames();

    /**
     * Sets the tablenames
     *
     * @param  string $tablenames
     */
    public function setTablenames($tablenames);

    /**
     * Sets the tablenames
     *
     * @param  string $tablenames
     * @param  string $entryId
     */
    public function setDebitor($tablenames, $entryId);
    /**
     * Get Debitor Object
     */
    public function getDebitor();
    /**
     * Get Link Uid
     */
    //public function getDebitorLink();
    //public function getDebitorSettings();
    /**
     * Returns the verbandId
     *
     * @return int
     */
    public function getVerbandId();
    public function getTenantId(): ?int;
    public function getVerband();
    //public function getVerbandTemplate(string $objectType);

    /**
     * Sets the verbandId
     *
     * @param  int $verbandId
     */
    public function setVerbandId($verbandId);

    /**
     * Add Amount
     *
     * @param float $amountInkl
     * @param float $amountExkl
     * @param float $taxRate        Mwst
     * @param text  $title
     */
    public function addAmount($amountInkl, $amountExkl, $taxRate, $title, $description = null);

    /**
     * Add Amount
     *
     * @param float $amountExkl
     * @param float $taxRate        Mwst
     * @param text  $title
     */
    public function addExkl($amountExkl, $taxRate, $title, $description = null);

    /**
     * Add Amount
     *
     * @param float $amountInkl
     * @param float $taxRate        Mwst
     * @param text  $title
     */
    public function addInkl($amountInkl, $taxRate, $title, $description = null);

    /**
     * Set Amount Inkl.
     *
     * @param float $amountInkl
     * @param float $taxRate        Mwst
     * @param text  $title
     */
    public function setInkl($amountInkl, $taxRate, $title, $description = null);

    /**
     * Returns the subtotal
     *
     * @return float
     */
    public function getSubtotal();

    /**
     * Sets the subtotal
     *
     * @param  float $subtotal
     */
    public function setSubtotal($subtotal);
    

    public function getCanDelete();
    public function getCanEdit();


    public function getSettingOneInvoicePerMail();
    public function getSettingMailTo();
}
