<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Repository;

use Ig\IgFibu\Database\Query\CreditQueryBuilder;
use Ig\IgFibu\Domain\Model\Credit;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Credits
 */
class CreditRepository extends BaseRepository
{
    protected static $tablename = 'tx_igfibu_domain_model_credit';
    protected static $queryBuilderClass = CreditQueryBuilder::class;
    protected static $localDebitorAttribute = 'debitor_id';
    protected static $localClientAttribute = 'tenant_id';
    protected $entryTablename = null;
    protected $entryPrimaryKey = null;
    protected static $modelClass = Credit::class;
    protected $entryKeywordSearchAttributes = [];
    protected $entryLanguageAttribute = null;
    protected $clientTablename = null; // Verband/Mandant table name
    protected $clientPrimaryKey = 'uid'; // Verband/Mandant Primary key

    protected $defaultOrderings = [
        'uid' => QueryInterface::ORDER_DESCENDING,
    ];
 
    /**
     * find open by search
     */
    public function findOpenBySearch(array $search = [])
    {
        $search['isDone'] = 0;
        return $this->findBySearch($search);
    }

    public function findOpenByDebitor(int $debitorId, int $tenantId = null)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('debitorId', $debitorId), $query->equals('isDone', false)];

        if ($tenantId > 0) {
            $constraints[] = $query->equals('tenantId', $tenantId);
        }
        $query->matching($query->logicalAnd(...$constraints));
        // oldest first
        $query->setOrderings(
            [
                'dueDate' => QueryInterface::ORDER_ASCENDING,
                'uid' => QueryInterface::ORDER_ASCENDING,
            ]
        );
        return $query->execute();
    }


    public function findByTenantDebitor(int $debitorId, int $tenantId = null)
    {
        $query = $this->createQuery();
        $constraints = [$query->equals('debitorId', $debitorId)];

        if ($tenantId > 0) {
            $constraints[] = $query->equals('tenantId', $tenantId);
        }
        $query->matching($query->logicalAnd(...$constraints));
        // oldest first
        $query->setOrderings(
            [
                'isDone' => QueryInterface::ORDER_ASCENDING,
                'dueDate' => QueryInterface::ORDER_ASCENDING,
                'uid' => QueryInterface::ORDER_ASCENDING,
            ]
        );
        return $query->execute();
    }
    
    public function findStatistikOpen(array $verbandsUids, array $search = [])
    {
        $sql = "SELECT CASE WHEN amount>=0 THEN 0 END AS search_from, CASE WHEN amount<0 THEN 0 END AS search_to, amount>=0  AS amount_is_positiv,CASE WHEN amount>=0 THEN 'Positiver Betrag' ELSE 'Negativer Betrag' END AS title, COUNT(1) AS entry_count, SUM(amount) AS sum_amount FROM tx_igfibu_domain_model_credit WHERE deleted=0 AND is_done=0 " . static::andVerband(
            $verbandsUids,
            $search
        ) . ' GROUP BY amount>=0 ORDER BY sum_amount';
        return $this->sqlFetchAll(static::$tablename, $sql);
    }
}
