<?php

namespace Ig\IgFibu\ViewHelpers\Debitor;

use Closure;
use Ig\IgFibu\Service\DebitorService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'contact uid', true);
        $this->registerArgument('as', 'string', 'name for contact object ', true);
        $this->registerArgument('type', 'string', 'debitor type', false, 'auto');
        $this->registerArgument('else', 'mixed', 'Value to be returned if no debitor is found.', false);
    }

        public function render(): string
    {
        $debitorUid = $this->arguments['uid'];
        $type = $this->arguments['type'];

        $debitorService = GeneralUtility::makeInstance(DebitorService::class);
        if ($debitorUid) {
            $debitor = $debitorService->getDebitorById($debitorUid, $type);
            $templateVariableContainer = $this->renderingContext->getVariableProvider();
            $templateVariableContainer->add($this->arguments['as'], $debitor);
            $output = $this->renderChildren();
            $templateVariableContainer->remove($this->arguments['as']);
        } else {
            $output = $this->arguments['else'] ?? '';
        }
        return $output;
    }
}
