<?php

namespace Ig\IgFibu\ViewHelpers;

use Closure;
use Exception;
use Ig\IgFibu\Domain\Model\Address;
use Ig\IgFibu\ReferenceFormatter\DefaultReferenceFormatter;
use Sprain\SwissQrBill as QrBill;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * <qrbill:paymentPart format="png" creditor="{creditor}" qrIban="{qrIban}" invoice="{invoice}" />
 *  <qrbill:paymentPart format="png" creditor="{creditor}" qrIban="{qrIban}" debitor="{invoice.debitor}" paymentReference= "{invoice.paymentReference}" currency="CHF" amount="{invoice.totalInkl}" />
 */



class PaymentPartViewHelper extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        //$this->registerUniversalTagAttributes();
        $this->registerArgument('format', 'string', 'Format (png,svg)', false, 'png');
        $this->registerArgument('qrIban', 'string', 'QR IBAN', false);
        $this->registerArgument('iban', 'string', 'IBAN', false);
        $this->registerArgument('creditor', 'array', 'creditor object', true);
        //$this->registerTagAttribute('invoice', 'object', 'invoice object', true);
        $this->registerArgument('debitor', 'array', 'Debitor object', true);
        $this->registerArgument('paymentReference', 'string', 'Payment Reference object', false);
        $this->registerArgument('invoiceUid', 'int', 'unique invoice uid', false);
        $this->registerArgument('debitorUid', 'int', 'unique debitor uid', false);
        $this->registerArgument('additionalInformation', 'string', 'additional information', false);
        $this->registerArgument('currency', 'string', 'currency CHF, EUR', true);
        $this->registerArgument('amount', 'string', 'amount', false, null);
        $this->registerArgument('language', 'string', 'language: de,fr,it,en', false, 'de');
    }

    protected function setZipCity(array &$address): array
    {
        if ($address['zip'] ?? false && $address['city'] ?? false) {
            return $address;
        } else {
            $zipCity = trim($address['zipCity'] ?? '');
            $pos = strpos($zipCity, ' ');
            if ($pos !== false) {
                $address['zip'] = substr($zipCity, 0, $pos);
                $address['city'] = trim(substr($zipCity, $pos + 1));
            } else {
                $address['zip'] = $zipCity;
                $address['city'] = '';
            }
        }
        return $address;
    }

    public function render(): string
    {
        $qrBill = QrBill\QrBill::create();

        $creditor = $this->arguments['creditor'];
        $debitor = $this->arguments['debitor'];
        $additionalInformation = $this->arguments['additionalInformation'] ?? null;

        // Add creditor information
        // Who will receive the payment and to which bank account?
        $this->setZipCity($creditor);

        $qrBill->setCreditor(
                QrBill\DataGroup\Element\StructuredAddress::createWithStreet(
                    $creditor['name'],
                    $creditor['address'],
                    '', // street number (can be in address)
                    $creditor['zip'],
                    $creditor['city'],
                    $creditor['country'] ?? 'CH'
                )
        );
        // ->getInvoicesadresseMitBetrieb()
        //var_dump($creditor);exit(0);
        /*
        $qrBill->setCreditorInformation(
        QrBill\DataGroup\Element\CreditorInformation::create(
        'CH4431999123000889012' // Note that this is a special QR-IBAN which are currently not yet available in real life (as of June 2019)
        ));
         */
        // Add debtor information
        // Who has to pay the invoice? This part is optional.
        //
        // Notice how you can use two different styles of addresses: CombinedAddress or StructuredAddress.
        // They are interchangeable for creditor as well as debtor.
        // trim($debitor['adz2'] . ' ' . $debitor['adz3'])
        if (is_array($debitor)) {
            $debitorName = $debitor['name'] ?? '';
            $debitorAddress = $debitor['address'] ?? '';
            $debitorAddressLine2 = $debitor['addressLine2'] ?? '';
            //$debitorZipCity = $debitor['zipCity'] ?? '';
            $this->setZipCity($debitor);
            $debitorZip = $debitor['zip'] ?? '';
            $debitorCity = $debitor['city'] ?? '';
            $debitorCountry = $debitor['country'] ?? '';
        } else {
            $debitorName = $debitor->getName();
            $debitorAddress = $debitor->getAddress();
            $debitorZip = $debitor->getZip();
            $debitorCity = $debitor->getCity();
            $debitorCountry = $debitor->getCountryIsoCode();
        }
        $qrBill->setUltimateDebtor(
            QrBill\DataGroup\Element\StructuredAddress::createWithStreet(
                $debitorName,//->getName(), // name
                $debitorAddress,//$debitor->getAddress(), // addressLine1
                '',
                $debitorZip,
                $debitorCity,
                $debitorCountry
            )
        );

        // Add payment amount information
        // What amount is to be paid?
        $amount = $this->arguments['amount'];//$invoice->getBetragEz();
        if ($amount === (float) 0) {
            $amount = null;
        }
        if ($amount < 0) {
            return '';
        }

        $qrBill->setPaymentAmountInformation(
            QrBill\DataGroup\Element\PaymentAmountInformation::create($this->arguments['currency'], $amount)
        );


        $referenceNumber = $this->arguments['paymentReference'];
        if (!isset($this->arguments['iban']) || $this->arguments['iban'] === '' || ($this->arguments['qrIban'] && ($debitorCountry == 'CH' || $debitorCountry == 'LI' || $debitorCountry == ''))) {
            // QR-IBAN is available -> use TYPE_QR
            $qrBill->setCreditorInformation(
                QrBill\DataGroup\Element\CreditorInformation::create(
                    $this->arguments['qrIban']//$verband->getQrIban() // Note that this is a special QR-IBAN
                )
            );
            $qrBill->setPaymentReference(
                QrBill\DataGroup\Element\PaymentReference::create(
                    QrBill\DataGroup\Element\PaymentReference::TYPE_QR,
                    $referenceNumber
                )
            );
        } else {
            // no QR-IBAN -> use SCOR
            $qrBill->setCreditorInformation(
                QrBill\DataGroup\Element\CreditorInformation::create(
                    $this->arguments['iban'] // normal IBAN for SCOR Reference Type
                )
            );
            //die($invoice->getEntryId() .','. $invoice->getUid().'='. $referenceNumber);
            if ($referenceNumber) {
                $debitorNumber = substr((string) $referenceNumber, 0, 7);
                $invoiceNumber = substr((string) $referenceNumber, -11, -1);
            } else {
                $debitorNumber = $this->arguments['debitorUid'] ?? 0;
                $invoiceNumber = $this->arguments['invoiceUid'] ?? 0;
                if ($invoiceNumber === 0) {
                    die('<h1>Error not invoiceNumber or referenceNumber given</h1>');
                }
            }
            $referenceFormatterClass = DefaultReferenceFormatter::class;
            $referenceFormatter = GeneralUtility::makeInstance($referenceFormatterClass);
            $address = GeneralUtility::makeInstance(Address::class);
            /*
            $address->setArray([
                'number' => $debitorNumber,
            ]);
            */
            $address->setUid($debitorNumber);
            $fakturaNummer = $referenceFormatter->getRFReference($address, $invoiceNumber);
            //$fakturaNummer = InvoiceUtility::getReference($debitorNumber, $invoiceNumber, '00');
            //$fakturaNummer = '00' . substr($referenceNumber,0, 7) . '3141' . substr($referenceNumber,-11, -1);
            $qrBill->setPaymentReference(
                QrBill\DataGroup\Element\PaymentReference::create(
                    QrBill\DataGroup\Element\PaymentReference::TYPE_SCOR,
                    QrBill\Reference\RfCreditorReferenceGenerator::generate($fakturaNummer)
                )
            );
        }

        if ($additionalInformation) {
            $qrBill->setAdditionalInformation(
                QrBill\DataGroup\Element\AdditionalInformation::create($additionalInformation)
            );
        }

        $languageCode = $this->arguments['language'];
        $output = new QrBill\PaymentPart\Output\HtmlOutput\HtmlOutput($qrBill, $languageCode);
        //var_dump($qrBill->getViolations());

        $output->setQrCodeImageFormat($this->arguments['format']);
        try {
            $output->setPrintable(false)
->getPaymentPart();
        } catch (Exception) {
            echo '<h1>QrBill Error in QR-Code generation</h1>';
            foreach ($qrBill->getViolations() as $violation) {
                print $violation->getPropertyPath() . ': ' . $violation->getMessage() . "\n";
            }
            exit;
        }
        return $output->setPrintable(false)
->getPaymentPart();
    }
}
