<?php
namespace IG\IgForm\Validation\Validator;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Resource\File;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;
use TYPO3\CMS\Form\Mvc\Validation\Exception\InvalidValidationOptionsException;

/**
 * Validator for form with two datepickers as start and end date
 */
class StartDateEndDateValidator extends AbstractValidator
{
    static $firstValue = null;
    
    /**
     * The given value is valid
     *
     * @param mixed $value
     * @api
     */
    public function isValid($value)
    {
        if(!self::$firstValue) {
            self::$firstValue = $value;
            $dateTimeFrom = self::$firstValue;
            $now = new \DateTime();
        
            if (!$dateTimeFrom instanceof \DateTime) {
                $this->addError(
                    $this->translateErrorMessage(
                        'validation.error.1505303233',
                        'ig_form'
                    ),
                    1505303233
                );
                return;
            }
            if ($dateTimeFrom < $now) {
                $this->addError(
                    $this->translateErrorMessage(
                        'validation.error.1505305433',
                        'ig_form'
                    ),
                    1505305433
                );
            }
            
            return;
        }
        
        $dateTimeFrom = self::$firstValue;
        $dateTimeTo = $value;
        
        if (!$dateTimeTo instanceof \DateTime) {
            $this->addError(
                $this->translateErrorMessage(
                    'validation.error.1505303234',
                    'ig_form'
                ),
                1505303233
            );
            return;
        }
        if ($dateTimeTo < $dateTimeFrom) {
            $this->addError(
                $this->translateErrorMessage(
                    'validation.error.1505305312',
                    'ig_form'
                ),
                1505305312
            );
        }
    }
}
