<?php
namespace IG\IgForm\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;
 
/**
 * ViewHelper zur Rückgabe eines geparsten tt_content Elementes
            <igForm:fileSize form="{form.formDefinition.processingRules.{element.identifier}.validators}" option="minimum" />
            <igForm:fileSize form="{form.formDefinition.processingRules.{element.identifier}.validators}" option="maximum" />
 */
class FileSizeLimitViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper {
    public function initializeArguments() {
        parent::initializeArguments();
        $this->registerArgument('form', \TYPO3\CMS\Form\Domain\Runtime\FormRuntime::class, 'Form', true, null);
        $this->registerArgument('element', \TYPO3\CMS\Form\Domain\Model\FormElements\FileUpload::class, 'Element', true, null);
        $this->registerArgument('option', 'string', 'Option', false, 'maximum');
        $this->registerArgument('labels', 'string', 'Labels', false, 'B|KB|MB|GB');
    }
    
    public function render() {
        $fileSizeLimit = null;
        $validators = $this->arguments['form']
                      ->getFormDefinition()
                      ->getProcessingRules()[$this->arguments['element']->getIdentifier()]
                      ->getValidators();
        
        foreach($validators as $validator) {
            if($validator instanceof \IG\IgForm\Validation\Validator\FileSizeValidator) {
                $fileSizeLimit = GeneralUtility::getBytesFromSizeMeasurement($validator->getOptions()[$this->arguments['option']]);
                break;
            }
        }
        if($fileSizeLimit !== null) {
            return GeneralUtility::formatSize($fileSizeLimit, $this->arguments['labels']);
        }
        
        return null;
    }
}
 
?>