<?php
declare(strict_types=1);
namespace IG\IgForm\Domain\Finishers;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Fluid\View\StandaloneView;
use TYPO3\CMS\Form\Domain\Finishers\Exception\FinisherException;
use TYPO3\CMS\Form\Domain\Model\FormElements\FileUpload;
use TYPO3\CMS\Form\Domain\Runtime\FormRuntime;
use TYPO3\CMS\Form\Service\TranslationService;
use TYPO3\CMS\Form\ViewHelpers\RenderRenderableViewHelper;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/**
 * This finisher sends an email to one recipient
 *
 * Options:
 *
 * - templatePathAndFilename (mandatory): Template path and filename for the mail body
 * - layoutRootPath: root path for the layouts
 * - partialRootPath: root path for the partials
 * - variables: associative array of variables which are available inside the Fluid template
 *
 * Example
 * =======
 *
 *  finishers:
 *    -
 *      identifier: AdvancedEmailToReceiver
 *      options:
 *        recipientFieldName: 'select-recipient'
 *        recipientAddresses:
 *           1: typo3@internetgalerie.ch
 *           2: typo2@internetgalerie.ch
 *
 * Scope: frontend
 */
class AdvancedEmailFinisher extends \TYPO3\CMS\Form\Domain\Finishers\EmailFinisher
{

    /**
     * @var array
     */
    protected $defaultOptions = [
        'recipientFieldName' => 'multicheckbox-1',
        'recipientAddresses' => [],
        'extraFieldName' =>'radiobutton-2',
        'extraFieldValue' =>'1',
        //'bcc' => '1',
    ];

    /**
     * Executes this finisher
     * @see AbstractFinisher::execute()
     *
     * @throws FinisherException
     */
    protected function executeInternal()
    {
        $formRuntime = $this->finisherContext->getFormRuntime();
        $formValues = $formRuntime->getFormState()->getFormValues();

        $recipientFieldName = $this->parseOption('recipientFieldName');
        $recipientAddresses = $this->parseOption('recipientAddresses');
	$extraFieldName = $this->parseOption('extraFieldName');
	$extraFieldValue = $this->parseOption('extraFieldValue');
        $sendBcc = false;
        if($formValues[$extraFieldName] == $extraFieldValue && is_array($formValues[$recipientFieldName]) && count($formValues[$recipientFieldName]) == 1) {
	    $recipient = $formValues[$recipientFieldName][0];
            $sendBcc = true;
            if($this->finisherIdentifier == 'AdvancedEmailToReceiver') { //??????
	      if(in_set($recipientAddresses[$recipient])) // oder in_array falls email wert kommt
                $recipientAddress = $recipientAddresses[$recipient];
                //echo $recipient;
            } else {
                $recipientAddress = $this->parseOption('recipientAddress');
                //echo $recipientAddress;
            }
        } else {
            $recipientAddress = $this->parseOption('recipientAddress');
        }
	//$this->setOption('blindCarbonCopyAddress', $recipientAddress);

	$this->setOption('recipientAddress', $recipientAddress);
	parent::executeInternal();
    }
}
