<?php
declare (strict_types = 1);
namespace IG\IgForm\Domain\Finishers;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Form\Domain\Finishers\Exception\FinisherException;

class IgRecaptchaFinisher extends \TYPO3\CMS\Form\Domain\Finishers\AbstractFinisher
{

    /**
     * @var array
     */
    protected $defaultOptions = [];

    protected function executeInternal()
    {
        $reCaptcha = GeneralUtility::makeInstance(\Evoweb\Recaptcha\Services\CaptchaService::class);
        $status = $reCaptcha->validateReCaptcha();
        $valid = $status['error'] !== '';
        if ($valid) {
            throw new FinisherException('Captcha error: ' . $status['error'], 1332155239);
        }
        return;
    }
}
